/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.domain;

import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.oauth.domain.ServiceApplication$callable$createServiceAuthorization;
import org.fenixedu.bennu.oauth.domain.ServiceApplicationAuthorization;
import org.fenixedu.bennu.oauth.domain.ServiceApplication_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ServiceApplication
extends ServiceApplication_Base {
    public static final Advice advice$createServiceAuthorization = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ServiceApplication() {
        this.init();
        this.setRedirectUrl("");
        this.setBennuServiceApplication(Bennu.getInstance());
        this.setBennu(null);
    }

    public void createServiceAuthorization(String string) {
        Object object = advice$createServiceAuthorization.perform((Callable)new ServiceApplication$callable$createServiceAuthorization(this, string));
    }

    static /* synthetic */ void advised$createServiceAuthorization(ServiceApplication this_, String accessToken) {
        this_.addServiceAuthorization(new ServiceApplicationAuthorization(accessToken));
    }

    public boolean hasServiceAuthorization(String accessToken) {
        return this.getServiceAuthorizationSet().stream().anyMatch(auth -> auth.matchesAccessToken(accessToken));
    }

    public boolean matches(String redirectUrl, String secret) {
        return this.matchesSecret(secret);
    }

    public Set<String> getWhitelist() {
        HashSet<String> whitelist = new HashSet<String>();
        JsonElement addresses = this.getIpAddresses();
        if (addresses == null || !addresses.isJsonArray()) {
            return whitelist;
        }
        for (JsonElement el : addresses.getAsJsonArray()) {
            whitelist.add(el.getAsString().trim());
        }
        return whitelist;
    }

    public boolean matchesIpAddress(String ipAddress) {
        Objects.requireNonNull(ipAddress);
        return this.getWhitelist().isEmpty() || this.getWhitelist().contains(ipAddress);
    }
}

