/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api;

import com.google.gson.JsonElement;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.oauth.annotation.OAuthEndpoint;
import org.fenixedu.bennu.oauth.api.OAuthAuthorizationProvider$callable$getOrCreateApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ApplicationUserAuthorization;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import org.fenixedu.bennu.oauth.util.OAuthUtils;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/oauth")
public class OAuthAuthorizationProvider
extends BennuRestResource {
    public static final Advice advice$getOrCreateApplicationUserSession = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @POST
    @Path(value="/provider/{app}/{username}")
    @OAuthEndpoint(serviceOnly=true, value={"OAUTH_AUTHORIZATION_PROVIDER"})
    @Produces(value={"application/json"})
    public JsonElement getTokens(@PathParam(value="app") ExternalApplication app, @PathParam(value="username") String username) {
        User user = User.findByUsername((String)username);
        if (user == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return OAuthUtils.getJsonTokens(this.getOrCreateApplicationUserSession(app, user));
    }

    private ApplicationUserSession getOrCreateApplicationUserSession(ExternalApplication externalApplication, User user) {
        return (ApplicationUserSession)((Object)advice$getOrCreateApplicationUserSession.perform((Callable)new OAuthAuthorizationProvider$callable$getOrCreateApplicationUserSession(this, externalApplication, user)));
    }

    static /* synthetic */ ApplicationUserSession advised$getOrCreateApplicationUserSession(OAuthAuthorizationProvider this_, ExternalApplication app, User user) {
        ApplicationUserAuthorization applicationUserAuthorization = app.getApplicationUserAuthorization(user).orElseGet(() -> new ApplicationUserAuthorization(user, app));
        ApplicationUserSession applicationUserSession = applicationUserAuthorization.getSessionSet().stream().filter(ApplicationUserSession::isAccessTokenValid).findAny().orElseGet(() -> {
            ApplicationUserSession session = new ApplicationUserSession();
            session.setApplicationUserAuthorization(applicationUserAuthorization);
            session.setTokens(OAuthUtils.generateToken((DomainObject)session), OAuthUtils.generateToken((DomainObject)session));
            return session;
        });
        return applicationUserSession;
    }
}

