/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api;

import com.google.gson.JsonElement;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.oauth.domain.ApplicationUserAuthorization;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ServiceApplication;
import pt.ist.fenixframework.FenixFramework;

@Path(value="/bennu-oauth/sessions/")
public class ExternalApplicationAuthorizationSessionResources
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{session}")
    public JsonElement authorizations(@PathParam(value="session") ApplicationUserAuthorization authorization) {
        User user = this.verifyAndGetRequestAuthor();
        if (!this.isManager(user) && authorization.getApplication() instanceof ServiceApplication) {
            return null;
        }
        if (authorization.getUser() == user || this.isManager(user)) {
            return this.view(authorization.getSessionSet());
        }
        return null;
    }

    @DELETE
    @Path(value="/{session}")
    public Response delete(@PathParam(value="session") ApplicationUserSession session) {
        User user = this.verifyAndGetRequestAuthor();
        if (!this.isManager(user) && session.getApplicationUserAuthorization().getApplication() instanceof ServiceApplication) {
            return null;
        }
        if (session.getApplicationUserAuthorization().getUser() == user || this.isManager(user)) {
            FenixFramework.atomic(() -> session.delete());
            return this.ok();
        }
        return null;
    }

    private boolean isManager(User user) {
        return Group.managers().isMember(user);
    }
}

