/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api;

import com.google.gson.JsonElement;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.oauth.domain.ApplicationUserAuthorization;
import org.fenixedu.bennu.oauth.domain.ServiceApplication;

@Path(value="/bennu-oauth/authorizations")
public class ExternalApplicationAuthorizationResources
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    public JsonElement myAuthorizations() {
        return this.view(this.verifyAndGetRequestAuthor().getApplicationUserAuthorizationSet().stream().filter(auth -> !(auth.getApplication() instanceof ServiceApplication)));
    }

    @DELETE
    @Path(value="/{authorization}")
    public Response delete(@PathParam(value="authorization") ApplicationUserAuthorization authorization) {
        User user = this.verifyAndGetRequestAuthor();
        if (authorization.getUser() == user || this.isManager(user)) {
            authorization.delete();
            return this.ok();
        }
        return null;
    }

    private boolean isManager(User user) {
        return Group.managers().isMember(user);
    }
}

