/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.jaxrs;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.oauth.annotation.OAuthEndpoint;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationScope;
import org.fenixedu.bennu.oauth.domain.ServiceApplication;
import org.fenixedu.bennu.oauth.util.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BennuOAuthAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(BennuOAuthAuthorizationFilter.class);
    @Context
    ResourceInfo requestInfo;
    @Context
    private HttpServletRequest httpRequest;

    BennuOAuthAuthorizationFilter() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String ipAddress = this.getIpAddress();
        String accessToken = this.getAccessToken(requestContext);
        OAuthEndpoint endpoint = this.requestInfo.getResourceMethod().getAnnotation(OAuthEndpoint.class);
        Optional<ServiceApplication> serviceApplication = this.extractServiceApplication(accessToken);
        if (endpoint.serviceOnly() && !serviceApplication.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        if (serviceApplication.isPresent()) {
            if (serviceApplication.get().isDeleted()) {
                this.sendError(requestContext, "accessTokenInvalidFormat", "Access Token not recognized.");
                return;
            }
            if (serviceApplication.get().isBanned()) {
                this.sendError(requestContext, "appBanned", "The application has been banned.");
                return;
            }
            if (!serviceApplication.get().hasServiceAuthorization(accessToken)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                return;
            }
            if (!Strings.isNullOrEmpty((String)ipAddress) && !serviceApplication.get().matchesIpAddress(ipAddress)) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                return;
            }
            Optional<ExternalApplicationScope> scope = ExternalApplicationScope.forKey(endpoint.value());
            if (!scope.isPresent() && endpoint.value().length > 0) {
                this.sendError(requestContext, "invalidScope", "Application doesn't have permissions to this endpoint.");
                return;
            }
            if (!scope.isPresent()) return;
            if (serviceApplication.get().getScopesSet().contains((Object)scope.get())) return;
            this.sendError(requestContext, "invalidScope", "Application doesn't have permissions to this endpoint.");
            return;
        }
        if (Authenticate.isLogged()) {
            logger.trace("Already logged in, proceeding...");
            return;
        }
        Optional<ExternalApplicationScope> scope = ExternalApplicationScope.forKey(endpoint.value());
        if (!scope.isPresent()) {
            logger.debug("Scope '{}' is not defined!", (Object)endpoint.value());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        Optional<ApplicationUserSession> session = this.extractUserSession(accessToken);
        if (!session.isPresent()) {
            this.sendError(requestContext, "accessTokenInvalidFormat", "Access Token not recognized.");
            return;
        }
        ApplicationUserSession appUserSession = session.get();
        ExternalApplication app = session.get().getApplicationUserAuthorization().getApplication();
        if (app.isDeleted()) {
            this.sendError(requestContext, "accessTokenInvalidFormat", "Access Token not recognized.");
            return;
        }
        if (app.isBanned()) {
            this.sendError(requestContext, "appBanned", "The application has been banned.");
            return;
        }
        if (!app.getScopesSet().contains((Object)scope.get())) {
            this.sendError(requestContext, "invalidScope", "Application doesn't have permissions to this getEndpoint().");
            return;
        }
        if (!appUserSession.matchesAccessToken(accessToken)) {
            this.sendError(requestContext, "accessTokenInvalid", "Access Token doesn't match.");
            return;
        }
        if (!appUserSession.isAccessTokenValid()) {
            this.sendError(requestContext, "accessTokenExpired", "The access has expired. Please use the refresh token endpoint to generate a new one.");
            return;
        }
        User foundUser = appUserSession.getApplicationUserAuthorization().getUser();
        if (foundUser.isLoginExpired()) {
            this.sendError(requestContext, "accessTokenInvalidFormat", "Access Token not recognized.");
            return;
        }
        Authenticate.mock((User)foundUser, (String)"OAuth Access Token");
    }

    private String getIpAddress() {
        if (this.httpRequest != null) {
            String xFor = null;
            xFor = this.httpRequest.getHeader("x-forwarded-for");
            if (!Strings.isNullOrEmpty((String)xFor)) {
                return xFor;
            }
            return this.httpRequest.getRemoteAddr();
        }
        return null;
    }

    private void sendError(ContainerRequestContext requestContext, String error, String errorDescription) {
        JsonObject json = new JsonObject();
        json.addProperty("error", error);
        json.addProperty("error_description", errorDescription);
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)json.toString()).type("application/json").build());
    }

    private Optional<ServiceApplication> extractServiceApplication(String accessToken) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            return Optional.empty();
        }
        try {
            String fullToken = new String(Base64.getDecoder().decode(accessToken), StandardCharsets.UTF_8);
            String[] accessTokenBuilder = fullToken.split(":");
            if (accessTokenBuilder.length != 2) {
                return Optional.empty();
            }
            return OAuthUtils.getDomainObject(accessTokenBuilder[0], ServiceApplication.class);
        }
        catch (IllegalArgumentException iea) {
            return Optional.empty();
        }
    }

    private Optional<ApplicationUserSession> extractUserSession(String accessToken) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            return Optional.empty();
        }
        try {
            String fullToken = new String(Base64.getDecoder().decode(accessToken), StandardCharsets.UTF_8);
            String[] accessTokenBuilder = fullToken.split(":");
            if (accessTokenBuilder.length != 2) {
                return Optional.empty();
            }
            return OAuthUtils.getDomainObject(accessTokenBuilder[0], ApplicationUserSession.class);
        }
        catch (IllegalArgumentException iea) {
            return Optional.empty();
        }
    }

    private String getAccessToken(ContainerRequestContext requestContext) {
        return this.getHeaderOrQueryParam(requestContext, "access_token");
    }

    private String getAuthorizationHeader(ContainerRequestContext request) {
        String authorization = request.getHeaderString("Authorization");
        if (authorization != null && authorization.startsWith("Bearer")) {
            return authorization.substring("Bearer".length()).trim();
        }
        return null;
    }

    private String getHeaderOrQueryParam(ContainerRequestContext requestContext, String paramName) {
        String paramValue = this.getAuthorizationHeader(requestContext);
        if (!Strings.isNullOrEmpty((String)paramValue)) {
            return paramValue;
        }
        paramValue = requestContext.getHeaderString(paramName);
        if (Strings.isNullOrEmpty((String)paramValue)) {
            paramValue = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)paramName);
        }
        return paramValue;
    }
}

