/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api;

import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.exceptions.AuthorizationException;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.oauth.api.json.ExternalApplicationForManagersAdapter;
import org.fenixedu.bennu.oauth.api.json.ExternalApplicationUsersAdapter;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import pt.ist.fenixframework.FenixFramework;

@Path(value="/bennu-oauth/applications")
public class ExternalApplicationResource
extends BennuRestResource {
    protected boolean isManager(User user) {
        return Group.managers().isMember(user);
    }

    private boolean isDeveloper(User user) {
        return Group.parse((String)"#developers").isMember(user);
    }

    protected User verifyAndGetRequestAuthor(ExternalApplication application) {
        User currentUser = super.verifyAndGetRequestAuthor();
        if (this.isManager(currentUser)) {
            return currentUser;
        }
        if (this.isDeveloper(currentUser) && application.getAuthor().equals((Object)currentUser)) {
            return currentUser;
        }
        throw AuthorizationException.unauthorized();
    }

    protected User verifyAndGetRequestAuthor() {
        User currentUser = super.verifyAndGetRequestAuthor();
        if (this.isDeveloper(currentUser)) {
            return currentUser;
        }
        throw AuthorizationException.unauthorized();
    }

    @GET
    @Produces(value={"application/json"})
    public JsonElement myApplications() {
        return this.view(this.verifyAndGetRequestAuthor().getOwnedApplicationSet().stream().filter(p -> p.isActive()));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{app}/authorizations")
    public JsonElement applicationsAuthorizations(@PathParam(value="app") ExternalApplication application) {
        this.accessControl((Group)Group.managers());
        return this.view((Object)application, ExternalApplicationUsersAdapter.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/all")
    public JsonElement allApplications() {
        this.accessControl((Group)Group.managers());
        return this.view(this.getAllApplications());
    }

    protected Set<? extends ExternalApplication> getAllApplications() {
        return Bennu.getInstance().getApplicationsSet();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public JsonElement createApplication(JsonElement json) {
        this.verifyAndGetRequestAuthor();
        return this.view((Object)this.create(json));
    }

    protected ExternalApplication create(JsonElement json) {
        return (ExternalApplication)((Object)this.create(json, ExternalApplication.class));
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{app}")
    public JsonElement updateApplication(@PathParam(value="app") ExternalApplication application, JsonElement json) {
        User currentUser = this.verifyAndGetRequestAuthor(application);
        return this.update(application, json, currentUser);
    }

    protected JsonElement update(ExternalApplication application, JsonElement json, User currentUser) {
        if (this.isManager(currentUser)) {
            return this.view(this.update(json, (Object)application, ExternalApplicationForManagersAdapter.class));
        }
        return this.view(this.update(json, (Object)application));
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{app}/ban")
    public Response banApplication(@PathParam(value="app") ExternalApplication application, JsonElement json) {
        this.accessControl((Group)Group.managers());
        FenixFramework.atomic(() -> application.setBanned());
        return this.ok();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{app}/active")
    public Response unbanApplication(@PathParam(value="app") ExternalApplication application, JsonElement json) {
        this.accessControl((Group)Group.managers());
        FenixFramework.atomic(() -> application.setActive());
        return this.ok();
    }

    @DELETE
    @Path(value="/{app}")
    public Response delete(@PathParam(value="app") ExternalApplication app) {
        this.verifyAndGetRequestAuthor(app);
        FenixFramework.atomic(() -> app.setDeleted());
        return this.ok();
    }

    @GET
    @Path(value="/{app}/logo")
    public Response logo(@PathParam(value="app") ExternalApplication app, @HeaderParam(value="If-None-Match") String ifNoneMatch) {
        Response response;
        block10: {
            if (app != null && app.getLogo() != null) {
                EntityTag etag = this.buildETag(app);
                if (etag.toString().equals(ifNoneMatch)) {
                    return Response.notModified((EntityTag)etag).build();
                }
                return Response.ok((Object)Base64.getDecoder().decode(app.getLogo()), (String)"image/jpeg").tag(etag).build();
            }
            InputStream placeholder = ((Object)((Object)this)).getClass().getResourceAsStream("/noapplication.png");
            try {
                response = Response.ok((Object)ByteStreams.toByteArray((InputStream)placeholder), (String)"image/png").build();
                if (placeholder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (placeholder != null) {
                        try {
                            placeholder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            }
            placeholder.close();
        }
        return response;
    }

    private EntityTag buildETag(ExternalApplication instance) {
        return EntityTag.valueOf((String)("W/\"" + instance.getLogo().length + "-" + instance.getExternalId() + "\""));
    }
}

