/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.domain;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.oauth.OAuthProperties;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession$callable$delete;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession$callable$setNewAccessToken;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession$callable$setTokens;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ApplicationUserSession
extends ApplicationUserSession_Base {
    public static final Advice advice$setTokens = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setNewAccessToken = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public void setCode(String code) {
        super.setCode(code);
        this.setCreationDate(new DateTime());
    }

    public boolean matchesCode(String code) {
        if (Strings.isNullOrEmpty((String)code) || Strings.isNullOrEmpty((String)this.getCode())) {
            return false;
        }
        return code.equals(this.getCode());
    }

    public boolean isCodeValid() {
        return !Strings.isNullOrEmpty((String)this.getCode()) && this.getCreationDate().plusSeconds(OAuthProperties.getConfiguration().getCodeExpirationSeconds().intValue()).isAfterNow();
    }

    public boolean matchesAccessToken(String accessToken) {
        if (Strings.isNullOrEmpty((String)this.getAccessToken()) || Strings.isNullOrEmpty((String)accessToken)) {
            return false;
        }
        return this.getAccessToken().equals(accessToken);
    }

    public boolean isAccessTokenValid() {
        return this.getCreationDate() != null && this.getCreationDate().plusSeconds(OAuthProperties.getConfiguration().getAccessTokenExpirationSeconds().intValue()).isAfterNow();
    }

    public boolean isRefreshTokenValid() {
        return !Strings.isNullOrEmpty((String)this.getRefreshToken());
    }

    public boolean matchesRefreshToken(String refreshToken) {
        if (Strings.isNullOrEmpty((String)this.getRefreshToken()) || Strings.isNullOrEmpty((String)refreshToken)) {
            return false;
        }
        return this.getRefreshToken().equals(refreshToken);
    }

    public void setTokens(String string, String string2) {
        Object object = advice$setTokens.perform((Callable)new ApplicationUserSession$callable$setTokens(this, string, string2));
    }

    static /* synthetic */ void advised$setTokens(ApplicationUserSession this_, String accessToken, String refreshToken) {
        this_.setAccessToken(accessToken);
        this_.setRefreshToken(refreshToken);
        this_.setCode(null);
        this_.setCreationDate(new DateTime());
    }

    public void setNewAccessToken(String string) {
        Object object = advice$setNewAccessToken.perform((Callable)new ApplicationUserSession$callable$setNewAccessToken(this, string));
    }

    static /* synthetic */ void advised$setNewAccessToken(ApplicationUserSession this_, String accessToken) {
        this_.setAccessToken(accessToken);
        this_.setCode(null);
        this_.setCreationDate(new DateTime());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ApplicationUserSession$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ApplicationUserSession this_) {
        this_.setCode(null);
        this_.setAccessToken(null);
        this_.setCreationDate(null);
        this_.setDeviceId(null);
        this_.setApplicationUserAuthorization(null);
        this_.setRefreshToken(null);
        this_.deleteDomainObject();
    }

    public boolean isActive() {
        return this.getCreationDate() != null;
    }
}

