/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationScope;
import pt.ist.fenixframework.FenixFramework;

@Path(value="/bennu-oauth/scopes")
public class ExternalApplicationScopesResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    public JsonElement getScopes() {
        this.verifyAndGetRequestAuthor();
        return this.view(Bennu.getInstance().getScopesSet().stream().filter(s -> s.getService() == false));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/all")
    public JsonElement getAllScopes() {
        this.accessControl((Group)Group.managers());
        return this.view(Bennu.getInstance().getScopesSet());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public JsonElement createScope(JsonElement json) {
        this.accessControl((Group)Group.managers());
        return this.view(this.create(json, ExternalApplicationScope.class));
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{scope}")
    public JsonElement updateScope(@PathParam(value="scope") ExternalApplicationScope scope, JsonElement json) {
        this.accessControl((Group)Group.managers());
        return this.view(this.update(json, (Object)scope));
    }

    @DELETE
    @Path(value="/{scope}")
    public Response delete(@PathParam(value="scope") ExternalApplicationScope scope) {
        this.accessControl((Group)Group.managers());
        FenixFramework.atomic(() -> {
            for (ExternalApplication externalApplication : Bennu.getInstance().getApplicationsSet()) {
                externalApplication.removeScope(scope);
            }
            Bennu.getInstance().removeScopes(scope);
        });
        return this.ok();
    }
}

