/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.servlet;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.util.DownloadUtil;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@WebServlet(urlPatterns={"/downloadFile/*"})
public class FileDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -6697201298218837492L;
    static final String SERVLET_PATH = "/downloadFile/";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        GenericFile file = FileDownloadServlet.getFileFromURL(request.getRequestURI());
        if (file == null) {
            response.sendError(404, "File not found");
        } else {
            if (request.getPathInfo().equals("/" + file.getExternalId())) {
                response.sendRedirect(FileDownloadServlet.getDownloadUrl(file));
                return;
            }
            if (file.isAccessible(Authenticate.getUser())) {
                DownloadUtil.downloadFile(file, request, response, "max-age=31536000");
            } else if (file.isPrivate() && !Authenticate.isLogged() && !"true".equals(request.getParameter("login_failed"))) {
                response.setStatus(401);
                response.sendRedirect(this.sendLoginRedirect(file));
            } else {
                response.sendError(403, "File not accessible");
            }
        }
    }

    public static String getDownloadUrl(GenericFile file) {
        return CoreConfiguration.getConfiguration().applicationUrl() + SERVLET_PATH + file.getExternalId() + "/" + file.getFilename();
    }

    private String sendLoginRedirect(GenericFile file) throws IOException {
        return CoreConfiguration.getConfiguration().applicationUrl() + "/login?callback=" + URLEncoder.encode(FileDownloadServlet.getDownloadUrl(file), Charsets.UTF_8.name());
    }

    public static GenericFile getFileFromURL(String url) {
        try {
            String[] parts = url.substring(url.indexOf(SERVLET_PATH)).replace(SERVLET_PATH, "").split("\\/");
            if (parts.length == 0) {
                return null;
            }
            DomainObject object = FenixFramework.getDomainObject((String)parts[0]);
            if (object instanceof GenericFile && FenixFramework.isDomainObjectValid((DomainObject)object)) {
                return (GenericFile)object;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

