/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.fenixedu.bennu.io.domain.DomainStorage_Base;
import org.fenixedu.bennu.io.domain.FileRawData;
import org.fenixedu.bennu.io.domain.GenericFile;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public final class DomainStorage
extends DomainStorage_Base {
    DomainStorage(String name) {
        this.setName(name);
    }

    public String store(GenericFile file, byte[] content) {
        String uniqueIdentification = file.getContentKey();
        DomainObject existingRawData = FenixFramework.getDomainObject((String)uniqueIdentification);
        if (existingRawData != null && existingRawData instanceof FileRawData) {
            ((FileRawData)existingRawData).delete();
        }
        if (content != null) {
            return new FileRawData(uniqueIdentification == null ? file.getExternalId() : uniqueIdentification, content).getExternalId();
        }
        return null;
    }

    public byte[] read(GenericFile file) {
        FileRawData rawData = (FileRawData)FenixFramework.getDomainObject((String)file.getContentKey());
        return rawData != null ? rawData.getContent() : null;
    }

    public InputStream readAsInputStream(GenericFile file) {
        byte[] read = this.read(file);
        return read != null ? new ByteArrayInputStream(read) : null;
    }
}

