/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.io.api.FileStorageResource$callable$createDomainStorageService;
import org.fenixedu.bennu.io.api.FileStorageResource$callable$deleteStorage;
import org.fenixedu.bennu.io.api.FileStorageResource$callable$innerSetDefault;
import org.fenixedu.bennu.io.domain.DomainStorage;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.LocalFileSystemStorage;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/bennu-io/storage")
public class FileStorageResource
extends BennuRestResource {
    public static final Advice advice$innerSetDefault = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDomainStorageService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$deleteStorage = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @POST
    @Path(value="/default/{storage}")
    public JsonElement setDefault(@PathParam(value="storage") String storageId) {
        this.accessControl((Group)Group.managers());
        this.innerSetDefault((FileStorage)this.readDomainObject(storageId));
        return this.all();
    }

    private void innerSetDefault(FileStorage fileStorage) {
        Object object = advice$innerSetDefault.perform((Callable)new FileStorageResource$callable$innerSetDefault(this, fileStorage));
    }

    static /* synthetic */ void advised$innerSetDefault(FileStorageResource this_, FileStorage storage) {
        FileSupport.getInstance().setDefaultStorage(storage);
    }

    @POST
    @Path(value="/domain/{name}")
    @Produces(value={"application/json"})
    public JsonElement createDomainStorage(@PathParam(value="name") String name) {
        this.accessControl((Group)Group.managers());
        return this.view((Object)this.createDomainStorageService(name));
    }

    @POST
    @Path(value="/lfs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement createLFSStorage(JsonElement json) {
        this.accessControl((Group)Group.managers());
        return this.view(this.create(json, LocalFileSystemStorage.class));
    }

    @GET
    @Produces(value={"application/json"})
    public JsonElement all() {
        this.accessControl((Group)Group.managers());
        return this.view(FileSupport.getInstance().getFileStorageSet(), "storages");
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public JsonObject fileCount() {
        this.accessControl((Group)Group.managers());
        JsonObject json = new JsonObject();
        for (FileStorage store : FileSupport.getInstance().getFileStorageSet()) {
            json.addProperty(store.getExternalId(), (Number)store.getFileSet().size());
        }
        return json;
    }

    private DomainStorage createDomainStorageService(String string) {
        return (DomainStorage)((Object)advice$createDomainStorageService.perform((Callable)new FileStorageResource$callable$createDomainStorageService(this, string)));
    }

    static /* synthetic */ DomainStorage advised$createDomainStorageService(FileStorageResource this_, String name) {
        return FileStorage.createNewDomainStorage(name);
    }

    @DELETE
    @Path(value="{oid}")
    @Produces(value={"application/json"})
    public JsonElement delete(@PathParam(value="oid") String storageOid) {
        this.accessControl((Group)Group.managers());
        FileStorage fileStorage = (FileStorage)this.readDomainObject(storageOid);
        JsonElement response = this.view((Object)fileStorage);
        Boolean deleteStorage2 = this.deleteStorage(fileStorage);
        if (deleteStorage2.booleanValue()) {
            return response;
        }
        throw new WebApplicationException(Response.Status.NO_CONTENT);
    }

    private Boolean deleteStorage(FileStorage fileStorage) {
        return (Boolean)advice$deleteStorage.perform((Callable)new FileStorageResource$callable$deleteStorage(this, fileStorage));
    }

    static /* synthetic */ Boolean advised$deleteStorage(FileStorageResource this_, FileStorage fileStorage) {
        return fileStorage.delete();
    }

    @PUT
    @Path(value="/convert/{oid}")
    public Response convertFileStorage(@PathParam(value="oid") String fileStorageOid) {
        this.accessControl((Group)Group.managers());
        GenericFile.convertFileStorages((FileStorage)this.readDomainObject(fileStorageOid));
        return this.ok();
    }
}

