/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.LocalFileToDelete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;

public class FileDeleterThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)FileDeleterThread.class.getName());

    @Override
    public void run() {
        FenixFramework.atomic(() -> FileSupport.getInstance().getDeleteSet().stream().forEach(FileDeleterThread::delete));
    }

    private static void delete(LocalFileToDelete file) {
        logger.debug("Deleting: {}", (Object)file.getFilePath());
        try {
            file.delete();
        }
        catch (Exception e) {
            logger.debug("Failed to delete file", (Throwable)e);
        }
    }
}

