/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.io.api.json.FileStorageConfigurationAdapter$callable$create;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.FileStorageConfiguration;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@DefaultJsonAdapter(value=FileStorageConfiguration.class)
public class FileStorageConfigurationAdapter
implements JsonAdapter<FileStorageConfiguration> {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public FileStorageConfiguration create(JsonElement jsonElement, JsonBuilder jsonBuilder) {
        return (FileStorageConfiguration)((Object)advice$create.perform((Callable)new FileStorageConfigurationAdapter$callable$create(this, jsonElement, jsonBuilder)));
    }

    static /* synthetic */ FileStorageConfiguration advised$create(FileStorageConfigurationAdapter this_, JsonElement el, JsonBuilder ctx) {
        JsonArray configs = el.getAsJsonArray();
        for (JsonElement configEl : configs) {
            JsonObject config = configEl.getAsJsonObject();
            String fileStorageConfigurationId = config.get("fileStorageConfigurationId").getAsString();
            String fileStorageId = config.get("fileStorageId").getAsString();
            this_.associate(fileStorageConfigurationId, fileStorageId);
        }
        return null;
    }

    private void associate(String fileStorageConfigurationId, String fileStorageId) {
        FileStorageConfiguration fsc = (FileStorageConfiguration)((Object)this.readDomainObject(fileStorageConfigurationId));
        FileStorage fs = (FileStorage)((Object)this.readDomainObject(fileStorageId));
        if (fsc != null) {
            fsc.setStorage(fs);
        }
    }

    private <T> T readDomainObject(String oid) {
        if ("null".equals(oid)) {
            return null;
        }
        return (T)FenixFramework.getDomainObject((String)oid);
    }

    public FileStorageConfiguration update(JsonElement arg0, FileStorageConfiguration arg1, JsonBuilder ctx) {
        throw new UnsupportedOperationException();
    }

    public JsonElement view(FileStorageConfiguration fsc, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", fsc.getExternalId());
        json.addProperty("type", fsc.getFileType());
        json.add("storage", ctx.view((Object)fsc.getStorage()));
        return json;
    }

    static /* bridge */ /* synthetic */ Object advised$create(FileStorageConfigurationAdapter this_, JsonElement jsonElement, JsonBuilder jsonBuilder) {
        return this_.create(jsonElement, jsonBuilder);
    }
}

