/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.util;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.GenericFile;

public class DownloadUtil {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=(?<start>\\d*)-(?<end>\\d*)");
    private static final int BUF_SIZE = 4096;

    public static void downloadFile(GenericFile file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DownloadUtil.downloadFile(file, request, response, CoreConfiguration.getConfiguration().staticCacheControl());
    }

    public static void downloadFile(GenericFile file, HttpServletRequest request, HttpServletResponse response, String cacheControl) throws IOException {
        block24: {
            String etag = "W/\"" + file.getExternalId() + "\"";
            response.setHeader("ETag", etag);
            if (cacheControl != null) {
                response.setHeader("Cache-Control", cacheControl);
            }
            response.setHeader("Accept-Ranges", "bytes");
            String contentType = file.getContentType();
            if (contentType.indexOf("video") != 0) {
                response.setHeader("Content-Disposition", "attachment");
            }
            response.setContentType(contentType);
            if (etag.equals(request.getHeader("If-None-Match"))) {
                response.setStatus(304);
                return;
            }
            long length = file.getSize();
            long start = 0L;
            long end = length - 1L;
            String range = request.getHeader("Range");
            if (range != null) {
                Matcher matcher = RANGE_PATTERN.matcher(range);
                boolean match = matcher.matches();
                if (match) {
                    try {
                        String startGroup = matcher.group("start");
                        start = Strings.isNullOrEmpty((String)startGroup) ? start : Long.valueOf(startGroup);
                        start = start < 0L ? 0L : start;
                        String endGroup = matcher.group("end");
                        end = Strings.isNullOrEmpty((String)endGroup) ? end : Long.valueOf(endGroup);
                        end = end > length - 1L ? length - 1L : end;
                    }
                    catch (NumberFormatException e) {
                        match = false;
                    }
                }
                if (!match) {
                    response.setHeader("Content-Range", "bytes */" + length);
                    response.sendError(416);
                    return;
                }
            }
            long contentLength = end - start + 1L;
            response.setHeader("Content-Length", Long.toString(contentLength));
            if (range != null) {
                response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + length);
                response.setStatus(206);
            } else {
                response.setStatus(200);
            }
            if (FileStorage.tryDownloadFile(file, request, response, start, end)) {
                return;
            }
            try (InputStream stream = file.getStream();){
                if (stream != null) {
                    try (ServletOutputStream out = response.getOutputStream();){
                        DownloadUtil.copyStream(stream, (OutputStream)out, start, contentLength);
                        out.flush();
                        break block24;
                    }
                }
                response.sendError(204, "File empty");
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out, long start, long bytesToRead) throws IOException {
        int len;
        ByteStreams.skipFully((InputStream)in, (long)start);
        byte[] buffer = new byte[4096];
        while (bytesToRead > 0L && (len = in.read(buffer)) != -1) {
            if (bytesToRead >= (long)len) {
                out.write(buffer, 0, len);
                bytesToRead -= (long)len;
                continue;
            }
            out.write(buffer, 0, (int)bytesToRead);
            bytesToRead = 0L;
        }
    }
}

