/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.io.domain.GroupBasedFile_Base;

public final class GroupBasedFile
extends GroupBasedFile_Base {
    public GroupBasedFile(String displayName, String filename, byte[] content, Group accessGroup) {
        this.init(displayName, filename, content);
        this.setAccessGroup(accessGroup);
    }

    public GroupBasedFile(String displayName, String filename, File file, Group accessGroup) throws IOException {
        this.init(displayName, filename, file);
        this.setAccessGroup(accessGroup);
    }

    public GroupBasedFile(String displayName, String filename, InputStream stream, Group accessGroup) throws IOException {
        this.init(displayName, filename, stream);
        this.setAccessGroup(accessGroup);
    }

    public Group getAccessGroup() {
        return this.getGroup().toGroup();
    }

    public void setAccessGroup(Group accessGroup) {
        this.setGroup(accessGroup.toPersistentGroup());
    }

    public boolean isAccessible(User user) {
        return this.getGroup().isMember(user);
    }

    public void delete() {
        this.setGroup(null);
        super.delete();
    }
}

