/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import com.google.common.base.Strings;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.FileStorageConfiguration;
import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.GenericFile$callable$updateFileStorage;
import org.fenixedu.bennu.io.domain.GenericFile_Base;
import org.fenixedu.commons.StringNormalizer;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class GenericFile
extends GenericFile_Base {
    private static final Logger logger;
    private static final Tika tika;
    private static final String DEFAULT_CHECKSUM_ALGORITHM = "murmur3_128";
    private static final HashFunction DEFAULT_HASH_FUNCTION;
    public static final Advice advice$updateFileStorage;

    protected GenericFile() {
        this.setFileSupport(FileSupport.getInstance());
        this.setCreationDate(new DateTime());
    }

    protected void init(String displayName, String filename, byte[] content) {
        if (content == null) {
            throw new NullPointerException("Content byte[] is null");
        }
        this.setDisplayName(displayName);
        this.setFilename(filename);
        this.setContent(content);
    }

    protected void init(String displayName, String filename, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("Content is null");
        }
        this.setDisplayName(displayName);
        this.setFilename(filename);
        this.setContent(file, filename);
    }

    protected void init(String displayName, String filename, InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Stream is empty");
        }
        this.setDisplayName(displayName);
        this.setFilename(filename);
        this.setContent(stream, filename);
    }

    public abstract boolean isAccessible(User var1);

    public boolean isPrivate() {
        return !this.isAccessible(null);
    }

    public DateTime getCreationDate() {
        return super.getCreationDate();
    }

    public Long getSize() {
        return super.getSize();
    }

    public String getContentType() {
        return super.getContentType();
    }

    public String getContentKey() {
        return super.getContentKey();
    }

    public String getChecksum() {
        if (super.getChecksum() == null) {
            return this.computeChecksum();
        }
        return super.getChecksum();
    }

    public String getChecksumAlgorithm() {
        if (super.getChecksumAlgorithm() == null) {
            return DEFAULT_CHECKSUM_ALGORITHM;
        }
        return super.getChecksumAlgorithm();
    }

    public void ensureChecksum() {
        if (super.getChecksum() == null) {
            this.setChecksum(this.computeChecksum());
            this.setChecksumAlgorithm(DEFAULT_CHECKSUM_ALGORITHM);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String computeChecksum() {
        Hasher hasher = DEFAULT_HASH_FUNCTION.newHasher();
        try (InputStream stream = this.getStream();){
            String string;
            block14: {
                OutputStream out = Funnels.asOutputStream((PrimitiveSink)hasher);
                try {
                    ByteStreams.copy((InputStream)stream, (OutputStream)out);
                    string = hasher.hash().toString();
                    if (out == null) break block14;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot compute checksum for " + this.getExternalId(), e);
        }
    }

    public void setFilename(String filename) {
        String nicerFilename = filename.substring(filename.lastIndexOf(47) + 1);
        String normalizedFilename = StringNormalizer.normalizePreservingCapitalizedLetters((String)nicerFilename);
        super.setFilename(normalizedFilename);
        if (this.getContentKey() != null) {
            this.setContentType(this.detectContentType(this.getContent(), normalizedFilename));
        }
    }

    private void setContent(File file, String filename) throws IOException {
        long size = file.length();
        this.setSize(size);
        FileStorage fileStorage = this.getFileStorage();
        String uniqueIdentification = fileStorage.store(this, file);
        this.setStorage(fileStorage);
        if (Strings.isNullOrEmpty((String)uniqueIdentification)) {
            throw new RuntimeException();
        }
        this.setContentKey(uniqueIdentification);
        this.setContentType(GenericFile.detectContentType(file, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContent(InputStream stream, String filename) throws IOException {
        CountingInputStream countingStream = new CountingInputStream(stream);
        BufferedInputStream buffer = new BufferedInputStream((InputStream)countingStream);
        FileStorage fileStorage = this.getFileStorage();
        buffer.mark(Integer.MAX_VALUE);
        try {
            this.setContentType(tika.detect((InputStream)new BufferedInputStream(buffer), filename));
            Writer nullWriter = Writer.nullWriter();
            IOUtils.copy((InputStream)buffer, (Writer)nullWriter);
            nullWriter.flush();
            nullWriter.close();
            this.setSize(countingStream.getCount());
        }
        finally {
            buffer.reset();
        }
        String uniqueIdentification = fileStorage.store(this, buffer);
        this.setStorage(fileStorage);
        if (Strings.isNullOrEmpty((String)uniqueIdentification)) {
            throw new RuntimeException();
        }
        this.setContentKey(uniqueIdentification);
    }

    private void setContent(byte[] content) {
        long size = content == null ? 0L : (long)content.length;
        this.setSize(size);
        FileStorage fileStorage = this.getFileStorage();
        String uniqueIdentification = fileStorage.store(this, content);
        this.setStorage(fileStorage);
        if (Strings.isNullOrEmpty((String)uniqueIdentification) && content != null) {
            throw new RuntimeException();
        }
        this.setContentKey(uniqueIdentification);
        if (content != null) {
            this.setContentType(this.detectContentType(content, this.getFilename()));
        }
    }

    public byte[] getContent() {
        return this.getStorage().read(this);
    }

    public InputStream getStream() {
        return this.getStorage().readAsInputStream(this);
    }

    public static void convertFileStorages(FileStorage fileStorageToUpdate) {
        if (fileStorageToUpdate != null) {
            try {
                for (GenericFile genericFile : FileSupport.getInstance().getFileSet()) {
                    if (fileStorageToUpdate != genericFile.getFileStorage() || fileStorageToUpdate == genericFile.getStorage()) continue;
                    genericFile.updateFileStorage();
                }
                logger.debug("FILE Conversion: DONE SUCESSFULLY!");
            }
            catch (Throwable e) {
                logger.debug("FILE Conversion: ABORTED!!!");
                e.printStackTrace();
            }
        }
    }

    private void updateFileStorage() {
        Object object = advice$updateFileStorage.perform((Callable)new GenericFile$callable$updateFileStorage(this));
    }

    static /* synthetic */ void advised$updateFileStorage(GenericFile this_) {
        this_.setContent(this_.getContent());
    }

    protected FileStorage getFileStorage() {
        FileStorage fileStorage = FileStorageConfiguration.readFileStorageByFileType(((Object)((Object)this)).getClass().getName());
        if (fileStorage == null) {
            return FileSupport.getInstance().getDefaultStorage();
        }
        return fileStorage;
    }

    @Deprecated
    protected String guessContentType(String filename) {
        return URLConnection.guessContentTypeFromName(filename);
    }

    protected String detectContentType(byte[] content, String filename) {
        return tika.detect(content, filename);
    }

    private static final String detectContentType(File file, String filename) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            String string = tika.detect((InputStream)stream, filename);
            return string;
        }
    }

    public void delete() {
        this.setContent(null);
        this.setStorage(null);
        this.setFileSupport(null);
        this.deleteDomainObject();
    }

    public static <T extends GenericFile> List<T> getFiles(Class<T> clazz) {
        ArrayList<GenericFile> files = new ArrayList<GenericFile>();
        for (GenericFile file : FileSupport.getInstance().getFileSet()) {
            if (!((Object)((Object)file)).getClass().equals(clazz)) continue;
            files.add(file);
        }
        return files;
    }

    static {
        advice$updateFileStorage = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(GenericFile.class);
        tika = new Tika();
        DEFAULT_HASH_FUNCTION = Hashing.murmur3_128();
    }
}

