/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import java.util.HashMap;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.FileStorageConfiguration_Base;
import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.GenericFile;
import pt.ist.fenixframework.DomainModelUtil;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public final class FileStorageConfiguration
extends FileStorageConfiguration_Base {
    private FileStorageConfiguration(Class<? extends DomainObject> fileTypeClass) {
        this.setFileSupport(FileSupport.getInstance());
        this.setFileType(fileTypeClass.getName());
        this.setStorage(FileSupport.getInstance().getDefaultStorage());
    }

    public String getFileType() {
        return super.getFileType();
    }

    public static FileStorage readFileStorageByFileType(String fileType) {
        for (FileStorageConfiguration fileStorageConfiguration : FileSupport.getInstance().getConfigurationSet()) {
            if (!fileStorageConfiguration.getFileType().equals(fileType)) continue;
            return fileStorageConfiguration.getStorage();
        }
        return null;
    }

    public static void createMissingStorageConfigurations() {
        HashMap<String, FileStorageConfiguration> configs = new HashMap<String, FileStorageConfiguration>();
        for (FileStorageConfiguration config : FileSupport.getInstance().getConfigurationSet()) {
            if (FenixFramework.getDomainModel().findClass(config.getFileType()) == null) {
                config.delete();
                continue;
            }
            configs.put(config.getFileType(), config);
        }
        for (Class fileTypeClass : DomainModelUtil.getDomainClassHierarchy(GenericFile.class, (boolean)true, (boolean)false)) {
            if (configs.containsKey(fileTypeClass.getName())) continue;
            new FileStorageConfiguration(fileTypeClass);
        }
    }

    private void delete() {
        this.setFileSupport(null);
        this.setStorage(null);
        this.deleteDomainObject();
    }
}

