/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.io.IOUtils;
import org.fenixedu.bennu.io.domain.DomainStorage;
import org.fenixedu.bennu.io.domain.FileStorage_Base;
import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.LocalFileSystemStorage;

public abstract class FileStorage
extends FileStorage_Base {
    protected FileStorage() {
        this.setFileSupport(FileSupport.getInstance());
    }

    public String getName() {
        return super.getName();
    }

    public Set<GenericFile> getFileSet() {
        return Collections.unmodifiableSet(super.getFileSet());
    }

    public String store(GenericFile genericFile, File file) throws IOException {
        return this.store(genericFile, Files.toByteArray((File)file));
    }

    public String store(GenericFile genericFile, InputStream stream) throws IOException {
        return this.store(genericFile, IOUtils.toByteArray((InputStream)stream));
    }

    public abstract String store(GenericFile var1, byte[] var2);

    public abstract byte[] read(GenericFile var1);

    public abstract InputStream readAsInputStream(GenericFile var1);

    public static DomainStorage createNewDomainStorage(String name) {
        return new DomainStorage(name);
    }

    public static LocalFileSystemStorage createNewFileSystemStorage(String name, String path, Integer treeDirectoriesNameLength) {
        return new LocalFileSystemStorage(name, path, treeDirectoriesNameLength);
    }

    public Boolean delete() {
        if (this.isCanBeDeleted()) {
            this.getConfigurationSet().clear();
            this.setFileSupport(null);
            this.deleteDomainObject();
            return true;
        }
        return false;
    }

    public boolean isCanBeDeleted() {
        return this.getFileSet().isEmpty();
    }

    public boolean isDefault() {
        return this.getFileSupportAsDefault() != null;
    }

    public static boolean tryDownloadFile(GenericFile file, HttpServletRequest request, HttpServletResponse response, long start, long end) throws IOException {
        return file.getFileStorage().tryLowLevelDownload(file, request, response, start, end);
    }

    protected boolean tryLowLevelDownload(GenericFile file, HttpServletRequest request, HttpServletResponse response, long start, long end) throws IOException {
        return false;
    }
}

