/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.domain;

import com.google.common.base.CharMatcher;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jvstm.PerTxBox;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.LocalFileSystemStorage_Base;
import org.fenixedu.bennu.io.domain.LocalFileToDelete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystemStorage
extends LocalFileSystemStorage_Base {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileSystemStorage.class);
    private transient PerTxBox<Map<String, FileWriteIntention>> fileIntentions;
    private static final Pattern BRACES_PATTERN = Pattern.compile("(\\{.+?\\})");

    LocalFileSystemStorage(String name, String path, Integer treeDirectoriesNameLength) {
        this.setName(name);
        this.setPath(path);
        this.setTreeDirectoriesNameLength(treeDirectoriesNameLength);
    }

    public String getPath() {
        return super.getPath();
    }

    public Integer getTreeDirectoriesNameLength() {
        return super.getTreeDirectoriesNameLength();
    }

    public String store(GenericFile genericFile, File file) {
        String uniqueIdentification = genericFile.getContentKey() == null ? genericFile.getExternalId() : genericFile.getContentKey();
        String fullPath = this.getFullPath(uniqueIdentification);
        LocalFileSystemStorage.ensureDirectoryExists(fullPath);
        HashMap<String, FileWriteIntention> map = new HashMap<String, FileWriteIntention>((Map)this.getPerTxBox().get());
        map.put(uniqueIdentification, new FileWriteIntention(fullPath + uniqueIdentification, file));
        this.getPerTxBox().put(map);
        return uniqueIdentification;
    }

    public String store(GenericFile genericFile, InputStream stream) {
        String uniqueIdentification = genericFile.getContentKey() == null ? genericFile.getExternalId() : genericFile.getContentKey();
        String fullPath = this.getFullPath(uniqueIdentification);
        LocalFileSystemStorage.ensureDirectoryExists(fullPath);
        HashMap<String, FileWriteIntention> map = new HashMap<String, FileWriteIntention>((Map)this.getPerTxBox().get());
        map.put(uniqueIdentification, new FileWriteIntention(fullPath + uniqueIdentification, stream));
        this.getPerTxBox().put(map);
        return uniqueIdentification;
    }

    public String store(GenericFile file, byte[] content) {
        String uniqueIdentification = file.getContentKey() == null ? file.getExternalId() : file.getContentKey();
        String fullPath = this.getFullPath(uniqueIdentification);
        if (content == null) {
            new LocalFileToDelete(fullPath + uniqueIdentification);
        } else {
            LocalFileSystemStorage.ensureDirectoryExists(fullPath);
            HashMap<String, FileWriteIntention> map = new HashMap<String, FileWriteIntention>((Map)this.getPerTxBox().get());
            map.put(uniqueIdentification, new FileWriteIntention(fullPath + uniqueIdentification, content));
            this.getPerTxBox().put(map);
        }
        return uniqueIdentification;
    }

    private static void ensureDirectoryExists(String fullPath) {
        File directory = new File(fullPath);
        if (!directory.exists()) {
            if (!directory.mkdirs() && !directory.exists()) {
                throw new RuntimeException("Could not create directory " + directory.getAbsolutePath());
            }
        } else if (!directory.isDirectory()) {
            throw new RuntimeException("Trying to create " + fullPath + " as a directory but, it already exists and it's not a directory");
        }
    }

    private String getFullPath(String uniqueIdentification) {
        return this.getAbsolutePath() + this.transformIDInPath(uniqueIdentification) + File.separatorChar;
    }

    public String getAbsolutePath() {
        File dir;
        String path = this.getPath();
        if (path.contains("{") && path.contains("}")) {
            Matcher matcher = BRACES_PATTERN.matcher(path);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String replaceStr = CharMatcher.anyOf((CharSequence)"{}").trimFrom((CharSequence)matcher.group());
                matcher.appendReplacement(result, System.getProperty(replaceStr));
            }
            matcher.appendTail(result);
            path = result.toString();
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separatorChar;
        }
        if (!(dir = new File(path)).exists()) {
            logger.debug("Filesystem storage {} directory does not exist, creating: {}", (Object)this.getName(), (Object)path);
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create base directory for " + this.getExternalId() + ": " + path);
            }
        }
        return path;
    }

    private String transformIDInPath(String uniqueIdentification) {
        Integer directoriesNameLength = this.getTreeDirectoriesNameLength();
        StringBuilder result = new StringBuilder();
        char[] idArray = uniqueIdentification.toCharArray();
        for (int i = 0; i < idArray.length; ++i) {
            if (i > 0 && i % directoriesNameLength == 0 && i + directoriesNameLength < uniqueIdentification.length()) {
                result.append(File.separatorChar);
            } else if (i + directoriesNameLength >= uniqueIdentification.length()) break;
            result.append(idArray[i]);
        }
        return result.toString();
    }

    public byte[] read(GenericFile file) {
        String uniqueIdentification = file.getContentKey();
        try {
            Map map = (Map)this.getPerTxBox().get();
            if (map.containsKey(uniqueIdentification)) {
                return ((FileWriteIntention)map.get(uniqueIdentification)).asByteArray();
            }
            return com.google.common.io.Files.toByteArray((File)new File(this.getFullPath(uniqueIdentification) + uniqueIdentification));
        }
        catch (IOException e) {
            throw new RuntimeException("error.store.file", e);
        }
    }

    public InputStream readAsInputStream(GenericFile file) {
        String uniqueIdentification = file.getContentKey();
        try {
            Map map = (Map)this.getPerTxBox().get();
            if (map.containsKey(uniqueIdentification)) {
                return ((FileWriteIntention)map.get(uniqueIdentification)).asInputStream();
            }
            return new FileInputStream(new File(this.getFullPath(uniqueIdentification) + uniqueIdentification));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("file.not.found", e);
        }
    }

    protected boolean tryLowLevelDownload(GenericFile file, HttpServletRequest request, HttpServletResponse response, long start, long end) {
        if (LocalFileSystemStorage.supportsSendfile(request)) {
            Optional<String> filePath = this.getSendfilePath(file.getContentKey());
            if (filePath.isPresent()) {
                LocalFileSystemStorage.handleSendfile(filePath.get(), request, response, start, end);
                return true;
            }
            return false;
        }
        return false;
    }

    private static void handleSendfile(String filename, HttpServletRequest request, HttpServletResponse response, long start, long end) {
        response.setHeader("X-Bennu-Sendfile", "true");
        request.setAttribute("org.apache.tomcat.sendfile.filename", (Object)filename);
        request.setAttribute("org.apache.tomcat.sendfile.start", (Object)start);
        request.setAttribute("org.apache.tomcat.sendfile.end", (Object)(end + 1L));
    }

    private static boolean supportsSendfile(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute("org.apache.tomcat.sendfile.support"));
    }

    private Optional<String> getSendfilePath(String uniqueIdentification) {
        String path = this.getFullPath(uniqueIdentification) + uniqueIdentification;
        if (new File(path).exists()) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    private synchronized PerTxBox<Map<String, FileWriteIntention>> getPerTxBox() {
        if (this.fileIntentions == null) {
            this.fileIntentions = new PerTxBox<Map<String, FileWriteIntention>>(Collections.emptyMap()){

                public void commit(Map<String, FileWriteIntention> map) {
                    for (FileWriteIntention i : map.values()) {
                        try {
                            i.write();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("error.store.file", e);
                        }
                    }
                }
            };
        }
        return this.fileIntentions;
    }

    private static class FileWriteIntention {
        private final String path;
        private final byte[] contents;
        private final File file;
        private final InputStream stream;

        FileWriteIntention(String path, byte[] contents) {
            this.path = path;
            this.contents = contents;
            this.file = null;
            this.stream = null;
        }

        FileWriteIntention(String path, File file) {
            this.path = path;
            this.contents = null;
            this.file = file;
            this.stream = null;
        }

        public FileWriteIntention(String path, InputStream stream) {
            this.path = path;
            this.contents = null;
            this.file = null;
            this.stream = stream;
        }

        public void write() throws IOException {
            if (this.contents != null) {
                com.google.common.io.Files.write((byte[])this.contents, (File)new File(this.path));
            } else if (this.stream != null) {
                try {
                    File file = new File(this.path);
                    FileOutputStream outputStream = new FileOutputStream(file);
                    ByteStreams.copy((InputStream)this.stream, (OutputStream)outputStream);
                    ((OutputStream)outputStream).close();
                }
                finally {
                    this.stream.close();
                }
            } else {
                Files.move(this.file.toPath(), Paths.get(this.path, new String[0]), new CopyOption[0]);
            }
        }

        public byte[] asByteArray() throws IOException {
            if (this.contents != null) {
                return this.contents;
            }
            return com.google.common.io.Files.toByteArray((File)this.file);
        }

        public InputStream asInputStream() throws IOException {
            if (this.contents != null) {
                return new ByteArrayInputStream(this.contents);
            }
            return new FileInputStream(this.file);
        }
    }
}

