/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.io.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.io.api.json.FileStorageAdapter;
import org.fenixedu.bennu.io.domain.FileStorage;
import org.fenixedu.bennu.io.domain.LocalFileSystemStorage;

@DefaultJsonAdapter(value=LocalFileSystemStorage.class)
public class LocalFileSystemStorageAdapter
implements JsonAdapter<LocalFileSystemStorage> {
    public LocalFileSystemStorage create(JsonElement el, JsonBuilder ctx) {
        JsonObject obj = el.getAsJsonObject();
        String name = obj.get("name").getAsString();
        String path = obj.get("path").getAsString();
        Integer treeDirectoriesNameLength = obj.get("treeDirectoriesNameLength").getAsInt();
        return FileStorage.createNewFileSystemStorage(name, path, treeDirectoriesNameLength);
    }

    public LocalFileSystemStorage update(JsonElement arg0, LocalFileSystemStorage arg1, JsonBuilder arg2) {
        throw new UnsupportedOperationException();
    }

    public JsonElement view(LocalFileSystemStorage fls, JsonBuilder ctx) {
        JsonObject json = ctx.view((Object)fls, FileStorageAdapter.class).getAsJsonObject();
        json.addProperty("path", fls.getPath());
        json.addProperty("treeDirectoriesNameLength", (Number)fls.getTreeDirectoriesNameLength());
        return json;
    }
}

