/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.cas.client.api;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.cas.client.CASClientConfiguration;
import org.fenixedu.bennu.cas.client.strategy.DefaultTicketValidationStrategy;
import org.fenixedu.bennu.cas.client.strategy.TicketValidationStrategy;
import org.fenixedu.bennu.core.domain.exceptions.AuthorizationException;
import org.fenixedu.bennu.portal.servlet.PortalLoginServlet;
import org.jasig.cas.client.validation.TicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cas-client/login")
public class CASResource {
    private static final Logger logger = LoggerFactory.getLogger(CASResource.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static TicketValidationStrategy VALIDATION_STRATEGY = null;
    public static final String CALLBACK_URL = "CALLBACK_URL";

    private TicketValidationStrategy getTicketValidator() {
        if (VALIDATION_STRATEGY == null) {
            try {
                VALIDATION_STRATEGY = (TicketValidationStrategy)Class.forName(CASClientConfiguration.getConfiguration().getCasLoginStrategy()).newInstance();
            }
            catch (Throwable t) {
                logger.error("Problem instantiating ticket validation strategy, falling back to default strategy", t);
                VALIDATION_STRATEGY = new DefaultTicketValidationStrategy();
            }
        }
        return VALIDATION_STRATEGY;
    }

    @GET
    @Path(value="/{callback}")
    public Response returnFromCAS(@QueryParam(value="ticket") String ticket, @PathParam(value="callback") String callback, @Context HttpServletRequest request, @Context HttpServletResponse response) throws UnsupportedEncodingException, URISyntaxException {
        if (!CASClientConfiguration.getConfiguration().casEnabled().booleanValue()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (Strings.isNullOrEmpty((String)ticket)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Optional<String> cb = CASResource.decode(callback).filter(PortalLoginServlet::validateCallback);
        if (!cb.isPresent()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Object actualCallback = cb.get();
        try {
            Cookie cookie;
            String requestURL = URLDecoder.decode(request.getRequestURL().toString(), CHARSET.name());
            String redirect = (String)request.getSession(false).getAttribute(CALLBACK_URL);
            this.getTicketValidator().validateTicket(ticket, requestURL, request, response);
            if (redirect != null) {
                request.getSession(false).setAttribute(CALLBACK_URL, (Object)redirect);
            }
            if ((cookie = CASResource.getCookie(request, "redirectToCas")) == null) {
                cookie = new Cookie("redirectToCas", "true");
                cookie.setPath("/");
                cookie.setMaxAge(86400);
                response.addCookie(cookie);
            }
        }
        catch (AuthorizationException | TicketValidationException e) {
            logger.debug(e.getMessage(), e);
            actualCallback = (String)actualCallback + (((String)actualCallback).contains("?") ? "&" : "?") + "login_failed=true";
        }
        return Response.status((Response.Status)Response.Status.FOUND).location(new URI((String)actualCallback)).build();
    }

    private static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        Cookie cookie = null;
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(cookieName)) continue;
                cookie = c;
                break;
            }
        }
        return cookie;
    }

    private static Optional<String> decode(String base64Callback) {
        try {
            return Optional.of(new String(Base64.getUrlDecoder().decode(base64Callback), CHARSET));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

