/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.cas.client;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.cas.client.CASClientConfiguration;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.login.LoginProvider;

public class CASLoginProvider
implements LoginProvider {
    private final Escaper escaper = UrlEscapers.urlPathSegmentEscaper();

    public void showLogin(HttpServletRequest request, HttpServletResponse response, String callback) throws IOException, ServletException {
        if (!StringUtils.isEmpty((String)callback)) {
            request.getSession(false).setAttribute("CALLBACK_URL", (Object)callback);
        }
        String actualCallbackToUse = CASClientConfiguration.getConfiguration().casServiceUrl();
        actualCallbackToUse = Base64.getUrlEncoder().encodeToString(actualCallbackToUse.getBytes(StandardCharsets.UTF_8));
        response.sendRedirect(CASClientConfiguration.getConfiguration().casServerUrl() + "/login?service=" + this.escaper.escape(CoreConfiguration.getConfiguration().applicationUrl() + "/api/cas-client/login/" + actualCallbackToUse));
    }

    public String getKey() {
        return "cas";
    }

    public String getName() {
        return "CAS";
    }

    public boolean isEnabled() {
        return CASClientConfiguration.getConfiguration().casEnabled();
    }
}

