/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSNormalizedString;

public class XSToken
extends XSNormalizedString {
    private static final String XS_TOKEN = "xs:token";

    public XSToken(String x) {
        super(x);
    }

    public XSToken() {
        this(null);
    }

    public String string_type() {
        return XS_TOKEN;
    }

    public String type_name() {
        return "token";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        String srcString = aat.string_value();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        } else {
            rs.add(new XSToken(srcString));
        }
        return rs;
    }

    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isToken = true;
        if (!super.isSatisfiesConstraints(srcString) || srcString.startsWith(" ") || srcString.endsWith(" ") || srcString.indexOf("  ") != -1) {
            isToken = false;
        }
        return isToken;
    }
}

