/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSNonNegativeInteger;

public class XSPositiveInteger
extends XSNonNegativeInteger {
    private static final String XS_POSITIVE_INTEGER = "xs:positiveInteger";

    public XSPositiveInteger() {
        this(BigInteger.valueOf(1L));
    }

    public XSPositiveInteger(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_POSITIVE_INTEGER;
    }

    public String type_name() {
        return "positiveInteger";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(1L);
            if (bigInt.compareTo(min) < 0) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(new XSPositiveInteger(bigInt));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }
}

