/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class XSNormalizedString
extends XSString {
    private static final String XS_NORMALIZEDSTRING = "xs:normalizedString";

    public XSNormalizedString(String x) {
        super(x);
    }

    public XSNormalizedString() {
        this(null);
    }

    public String string_type() {
        return XS_NORMALIZEDSTRING;
    }

    public String type_name() {
        return "normalizedString";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        String srcString = aat.string_value();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        } else {
            rs.add(new XSNormalizedString(srcString));
        }
        return rs;
    }

    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isNormalizedStr = true;
        if (srcString.indexOf("\r") != -1 || srcString.indexOf("\n") != -1 || srcString.indexOf("\t") != -1) {
            isNormalizedStr = false;
        }
        return isNormalizedStr;
    }
}

