/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSNonNegativeInteger
extends XSInteger {
    private static final String XS_NON_NEGATIVE_INTEGER = "xs:nonNegativeInteger";

    public XSNonNegativeInteger() {
        this(BigInteger.valueOf(0L));
    }

    public XSNonNegativeInteger(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_NON_NEGATIVE_INTEGER;
    }

    public String type_name() {
        return "nonNegativeInteger";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger min = BigInteger.valueOf(0L);
            if (bigInt.compareTo(min) < 0) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(new XSNonNegativeInteger(bigInt));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }
}

