/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import repackage.org.apache.xerces.impl.dv.util.Base64;
import repackage.org.apache.xerces.impl.dv.util.HexBin;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class XSHexBinary
extends CtrType
implements CmpEq {
    private static final String XS_HEX_BINARY = "xs:hexBinary";
    private String _value;

    public XSHexBinary(String x) {
        this._value = x;
    }

    public XSHexBinary() {
        this(null);
    }

    public String string_type() {
        return XS_HEX_BINARY;
    }

    public String type_name() {
        return "hexBinary";
    }

    public String string_value() {
        return this._value.toUpperCase();
    }

    public String value() {
        return this._value;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        String str_value = aat.string_value();
        if (!(aat instanceof XSHexBinary || aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof XSBase64Binary)) {
            throw DynamicError.cant_cast(null);
        }
        if (aat instanceof XSUntypedAtomic || aat instanceof XSString) {
            String[] nonHexValues = null;
            try {
                nonHexValues = str_value.split("[0-9a-fA-F]");
            }
            catch (Exception ex) {
                throw DynamicError.throw_type_error();
            }
            String[] binValues = null;
            try {
                binValues = str_value.split("[0-1]");
            }
            catch (Exception ex) {
                throw DynamicError.throw_type_error();
            }
            if (nonHexValues.length > 0 || binValues.length == 0) {
                throw DynamicError.invalidForCastConstructor();
            }
        }
        byte[] decodedValue = null;
        if (aat instanceof XSBase64Binary) {
            decodedValue = Base64.decode(str_value);
            decodedValue = HexBin.encode(decodedValue).getBytes();
        } else {
            decodedValue = str_value.getBytes();
        }
        if (decodedValue == null) {
            throw DynamicError.throw_type_error();
        }
        rs.add(new XSHexBinary(new String(decodedValue)));
        return rs;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        String valToCompare = arg.string_value();
        byte[] value1 = HexBin.decode(this._value);
        byte[] value2 = HexBin.decode(valToCompare);
        if (value2 == null) {
            return false;
        }
        int len = value1.length;
        if (len != value2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (value1[i] != value2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

