/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class XSGYearMonth
extends CalendarType
implements CmpEq {
    private static final String XS_G_YEAR_MONTH = "xs:gYearMonth";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;
    static /* synthetic */ Class class$0;

    public XSGYearMonth(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        if (tz != null) {
            this._timezoned = true;
            this._tz = tz;
        }
    }

    public XSGYearMonth() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    public String type_name() {
        return "gYearMonth";
    }

    public static XSGYearMonth parse_gYearMonth(String str) {
        String yearMonth = "";
        String dayTime = "-01T00:00:00.0";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
            if (index == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            yearMonth = str.substring(0, index);
            yearMonth = String.valueOf(yearMonth) + dayTime;
            yearMonth = String.valueOf(yearMonth) + str.substring(index, str.length());
        } else {
            yearMonth = String.valueOf(str) + dayTime;
        }
        XSDateTime dt = XSDateTime.parseDateTime(yearMonth);
        if (dt == null) {
            return null;
        }
        return new XSGYearMonth(dt.calendar(), dt.tz());
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSGYearMonth val = this.castGYearMonth(aat);
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(val);
        return rs;
    }

    protected boolean isGDataType(AnyAtomicType aat) {
        String type = aat.string_type();
        return type.equals("xs:gMonthDay") || type.equals("xs:gDay") || type.equals("xs:gMonth") || type.equals("xs:gYear");
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSGYearMonth) {
            return true;
        }
        if (aat instanceof XSDate) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDateTime;
    }

    private XSGYearMonth castGYearMonth(AnyAtomicType aat) {
        if (aat instanceof XSGYearMonth) {
            XSGYearMonth gym = (XSGYearMonth)aat;
            return new XSGYearMonth(gym.calendar(), gym.tz());
        }
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSGYearMonth(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSGYearMonth(dateTime.calendar(), dateTime.tz());
        }
        return XSGYearMonth.parse_gYearMonth(aat.string_value());
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.year(), 4);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        if (this.timezoned()) {
            int hrs = this.tz().hours();
            int min = this.tz().minutes();
            double secs = this.tz().seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = String.valueOf(ret) + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this.tz().negative() ? String.valueOf(tZoneStr) + "-" : String.valueOf(tZoneStr) + "+";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(hrs, 2);
                tZoneStr = String.valueOf(tZoneStr) + ":";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(min, 2);
                ret = String.valueOf(ret) + tZoneStr;
            }
        }
        return ret;
    }

    public String string_type() {
        return XS_G_YEAR_MONTH;
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSGYearMonth");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSGYearMonth val = (XSGYearMonth)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    public XSDuration tz() {
        return this._tz;
    }
}

