/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import repackage.javax.xml.datatype.DatatypeConfigurationException;
import repackage.javax.xml.datatype.DatatypeFactory;
import repackage.javax.xml.datatype.Duration;
import repackage.javax.xml.datatype.XMLGregorianCalendar;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSYearMonthDuration;

public class XSDate
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private static final String XS_DATE = "xs:date";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public XSDate(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSDate() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    public String type_name() {
        return "date";
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XSDuration t = this.tz();
        if (t != null) {
            t = (XSDuration)t.clone();
        }
        return new XSDate(c, t);
    }

    public static XSDate parse_date(String str) {
        String date = "";
        String time = "T00:00:00.0";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
            if (index == -1) {
                return null;
            }
            if ((index = str.indexOf(45, index + 1)) == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            date = str.substring(0, index);
            date = String.valueOf(date) + time;
            date = String.valueOf(date) + str.substring(index, str.length());
        } else {
            date = String.valueOf(str) + time;
        }
        XSDateTime dt = XSDateTime.parseDateTime(date);
        if (dt == null) {
            return null;
        }
        return new XSDate(dt.calendar(), dt.tz());
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        if (!this.isCastable(aat)) {
            throw DynamicError.invalidType();
        }
        XSDate dt = this.castDate(aat);
        if (dt == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(dt);
        return rs;
    }

    private boolean isCastable(AnyType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        if (aat instanceof XSDateTime) {
            return true;
        }
        return aat instanceof XSDate;
    }

    private XSDate castDate(AnyType aat) {
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSDate(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSDate(dateTime.calendar(), dateTime.tz());
        }
        return XSDate.parse_date(aat.string_value());
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        Calendar adjustFortimezone = this.calendar();
        if (adjustFortimezone.get(0) == 0) {
            ret = String.valueOf(ret) + "-";
        }
        ret = String.valueOf(ret) + XSDateTime.pad_int(adjustFortimezone.get(1), 4);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        if (this.timezoned()) {
            int hrs = this._tz.hours();
            int min = this._tz.minutes();
            double secs = this._tz.seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = String.valueOf(ret) + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this._tz.negative() ? String.valueOf(tZoneStr) + "-" : String.valueOf(tZoneStr) + "+";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(hrs, 2);
                tZoneStr = String.valueOf(tZoneStr) + ":";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(min, 2);
                ret = String.valueOf(ret) + tZoneStr;
            }
        }
        return ret;
    }

    public String string_type() {
        return XS_DATE;
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public XSDuration tz() {
        return this._tz;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDate val = (XSDate)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDate val = (XSDate)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.before(thatcal);
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDate val = (XSDate)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.after(thatcal);
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            throw DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        if (!(at instanceof XSDate || at instanceof XSYearMonthDuration || at instanceof XSDayTimeDuration)) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof XSDate) {
            return this.minusXSDate(arg);
        }
        if (at instanceof XSYearMonthDuration) {
            return this.minusXSYearMonthDuration(at);
        }
        if (at instanceof XSDayTimeDuration) {
            return this.minusXSDayTimeDuration(at);
        }
        return null;
    }

    private ResultSequence minusXSDayTimeDuration(AnyType at) {
        XSDuration val = (XSDuration)at;
        try {
            XSDate res = (XSDate)this.clone();
            try {
                XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)this.calendar());
                Duration dtduration = DatatypeFactory.newInstance().newDuration(val.string_value());
                xmlCal.add(dtduration.negate());
                res = new XSDate(xmlCal.toGregorianCalendar(), res.tz());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
            return ResultSequenceFactory.create_new(res);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private ResultSequence minusXSYearMonthDuration(AnyType at) {
        XSYearMonthDuration val = (XSYearMonthDuration)at;
        try {
            XSDate res = (XSDate)this.clone();
            res.calendar().add(2, val.monthValue() * -1);
            return ResultSequenceFactory.create_new(res);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private ResultSequence minusXSDate(ResultSequence arg) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDate val = (XSDate)NumericType.get_single_type(arg, (Class)clazz);
        Duration dtduration = null;
        try {
            Calendar thisCal = this.normalizeCalendar(this.calendar(), this.tz());
            Calendar thatCal = this.normalizeCalendar(val.calendar(), val.tz());
            long duration = thisCal.getTimeInMillis() - thatCal.getTimeInMillis();
            dtduration = DatatypeFactory.newInstance().newDuration(duration);
            return ResultSequenceFactory.create_new(XSDayTimeDuration.parseDTDuration(dtduration.toString()));
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        try {
            if (at instanceof XSYearMonthDuration) {
                XSYearMonthDuration val = (XSYearMonthDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(2, val.monthValue());
                return ResultSequenceFactory.create_new(res);
            }
            if (at instanceof XSDayTimeDuration) {
                XSDayTimeDuration val = (XSDayTimeDuration)at;
                XSDate res = (XSDate)this.clone();
                int days = val.days();
                if (val.negative()) {
                    days *= -1;
                }
                res.calendar().add(5, days);
                res.calendar().add(14, (int)(val.time_value() * 1000.0));
                return ResultSequenceFactory.create_new(res);
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException err) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }
}

