/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Locale;

public class XPathDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = -8229885955864187400L;
    private static final String NEG_INFINITY = "-INF";
    private static final String POS_INFINITY = "INF";

    public XPathDecimalFormat(String pattern) {
        super(pattern, new DecimalFormatSymbols(Locale.US));
    }

    public String xpathFormat(Object obj) {
        return this.formatXPath(obj);
    }

    private String formatXPath(Object obj) {
        String curPattern = this.toPattern();
        String newPattern = curPattern.replaceAll("E0", "");
        if (obj instanceof Float) {
            return this.formatFloatValue(obj, curPattern, newPattern);
        }
        if (obj instanceof Double) {
            return this.formatDoubleValue(obj, curPattern, newPattern);
        }
        return super.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private String formatDoubleValue(Object obj, String curPattern, String newPattern) {
        Double doubleValue = (Double)obj;
        if (this.isDoubleNegativeInfinity(doubleValue)) {
            return NEG_INFINITY;
        }
        if (this.isDoublePositiveInfinity(doubleValue)) {
            return POS_INFINITY;
        }
        this.doubleXPathPattern(obj, curPattern, newPattern);
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private void doubleXPathPattern(Object obj, String curPattern, String newPattern) {
        BigDecimal doubValue = new BigDecimal((Double)obj);
        BigDecimal minValue = new BigDecimal("-1E6");
        BigDecimal maxValue = new BigDecimal("1E6");
        if (doubValue.compareTo(minValue) > 0 && doubValue.compareTo(maxValue) < 0) {
            this.applyPattern(newPattern);
        } else {
            this.applyPattern(curPattern.replaceAll("0\\.#", "0.0"));
        }
    }

    private boolean isDoublePositiveInfinity(Double doubleValue) {
        return doubleValue == Double.POSITIVE_INFINITY;
    }

    private boolean isDoubleNegativeInfinity(Double doubleValue) {
        return doubleValue == Double.NEGATIVE_INFINITY;
    }

    private String formatFloatValue(Object obj, String curPattern, String newPattern) {
        Float floatValue = (Float)obj;
        if (this.isFloatNegInfinity(floatValue)) {
            return NEG_INFINITY;
        }
        if (this.isFloatPosInfinity(floatValue)) {
            return POS_INFINITY;
        }
        this.floatXPathPattern(curPattern, newPattern, floatValue);
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private boolean isFloatPosInfinity(Float floatValue) {
        return floatValue.floatValue() == Float.POSITIVE_INFINITY;
    }

    private boolean isFloatNegInfinity(Float floatValue) {
        return floatValue.floatValue() == Float.NEGATIVE_INFINITY;
    }

    private void floatXPathPattern(String curPattern, String newPattern, Float floatValue) {
        if (floatValue.floatValue() > -1000000.0f && floatValue.floatValue() < 1000000.0f) {
            this.applyPattern(newPattern);
        } else if (floatValue.floatValue() <= -1000000.0f) {
            this.applyPattern(curPattern.replaceAll("0\\.#", "0.0"));
        }
    }
}

