/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.types;

import repackage.org.apache.xerces.dom.PSVIAttrNSImpl;
import repackage.org.apache.xerces.xs.XSTypeDefinition;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import repackage.org.w3c.dom.Attr;
import repackage.org.w3c.dom.TypeInfo;

public class AttrType
extends NodeType {
    private static final String ATTRIBUTE = "attribute";
    private Attr _value;

    public AttrType() {
        this(null);
    }

    public AttrType(Attr v) {
        super(v);
        this._value = v;
    }

    public String string_type() {
        return ATTRIBUTE;
    }

    public String string_value() {
        return this._value.getValue();
    }

    public ResultSequence typed_value() throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (!(this._value instanceof PSVIAttrNSImpl)) {
            rs.add(new XSUntypedAtomic(this.string_value()));
        } else {
            PSVIAttrNSImpl typeInfo = (PSVIAttrNSImpl)this._value;
            XSTypeDefinition typeDef = typeInfo.getTypeDefinition();
            if (typeDef != null) {
                rs = this.getXDMTypedValue(typeDef, typeInfo.getItemValueTypes());
            } else {
                rs.add(new XSUntypedAtomic(this.string_value()));
            }
        }
        return rs;
    }

    public QName node_name() {
        QName name = new QName(this._value.getPrefix(), this._value.getLocalName(), this._value.getNamespaceURI());
        return name;
    }

    public boolean isID() {
        return this.isAttrType("ID");
    }

    public boolean isIDREF() {
        return this.isAttrType("IDREF");
    }

    protected boolean isAttrType(String typeName) {
        if (this._value.getOwnerDocument().isSupported("Core", "3.0")) {
            return this.typeInfo(typeName);
        }
        return false;
    }

    private boolean typeInfo(String typeName) {
        TypeInfo typeInfo = this._value.getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }
}

