/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.StaticContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import repackage.org.w3c.dom.Attr;
import repackage.org.w3c.dom.Element;

public class FnResolveQName
extends Function {
    private static Collection _expected_args = null;

    public FnResolveQName() {
        super(new QName("resolve-QName"), 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnResolveQName.resolve_QName(args, this.static_context());
    }

    public static ResultSequence resolve_QName(Collection args, StaticContext sc) throws DynamicError {
        Collection cargs = args;
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return rs;
        }
        ResultSequence arg2 = (ResultSequence)argiter.next();
        String name = FnData.atomize(arg1.first()).string_value();
        QName qn = QName.parse_QName(name);
        if (qn == null) {
            throw DynamicError.lexical_error(null);
        }
        ElementType xselement = (ElementType)arg2.first();
        Element element = (Element)xselement.node_value();
        if (qn.prefix() != null) {
            String namespaceURI = element.lookupNamespaceURI(qn.prefix());
            if (namespaceURI == null) {
                namespaceURI = FnResolveQName.lookupNamespaceURI(element, qn.prefix());
            }
            if (namespaceURI == null) {
                throw DynamicError.invalidPrefix();
            }
            qn.set_namespace(namespaceURI);
        } else if (qn.local().equals(element.getLocalName()) && element.isDefaultNamespace(element.getNamespaceURI())) {
            qn.set_namespace(element.getNamespaceURI());
        }
        rs.add(qn);
        return rs;
    }

    private static String lookupNamespaceURI(Element element, String prefix) {
        String nsUri = null;
        Attr attNode = element.getAttributeNode("xmlns:" + prefix);
        if (attNode != null) {
            nsUri = attNode.getValue();
        } else if (element.getParentNode() instanceof Element) {
            FnResolveQName.lookupNamespaceURI((Element)element.getParentNode(), prefix);
        }
        return nsUri;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new ElementType(), 0));
        }
        return _expected_args;
    }
}

