/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnReplace
extends Function {
    private static Collection _expected_args = null;

    public FnReplace() {
        super(new QName("replace"), 3, 4);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnReplace.replace(args);
    }

    public static ResultSequence replace(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnReplace.expected_args());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        String str1 = "";
        if (!arg1.empty()) {
            str1 = ((XSString)arg1.first()).value();
        }
        ResultSequence arg2 = (ResultSequence)argiter.next();
        ResultSequence arg3 = (ResultSequence)argiter.next();
        ResultSequence arg4 = null;
        if (argiter.hasNext()) {
            arg4 = (ResultSequence)argiter.next();
            String flags = arg4.first().string_value();
            if (flags.length() == 0) {
                arg4 = null;
            } else if (!FnReplace.isFlagValid(flags)) {
                throw new DynamicError("FORX0001", "Invalid regular expression. flags");
            }
        }
        String pattern = ((XSString)arg2.first()).value();
        String replacement = ((XSString)arg3.first()).value();
        try {
            rs.add(new XSString(str1.replaceAll(pattern, replacement)));
            return rs;
        }
        catch (PatternSyntaxException err) {
            throw DynamicError.regex_error(null);
        }
        catch (IllegalArgumentException ex) {
            throw new DynamicError("FORX0004", "invalid regex.");
        }
        catch (IndexOutOfBoundsException ex) {
            String className = ex.getClass().getName();
            if (className.endsWith("StringIndexOutOfBoundsException")) {
                throw new DynamicError("FORX0004", "result out of bounds");
            }
            throw new DynamicError("FORX0003", "invalid regex.");
        }
        catch (Exception ex) {
            throw new DynamicError("FORX0004", "invalid regex.");
        }
    }

    private static boolean isFlagValid(String flag) {
        char[] flags = new char[]{'s', 'm', 'i', 'x'};
        int i = 0;
        while (i < flags.length) {
            if (flag.indexOf(flags[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

