/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSID;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import repackage.org.w3c.dom.Attr;
import repackage.org.w3c.dom.Element;
import repackage.org.w3c.dom.NamedNodeMap;
import repackage.org.w3c.dom.Node;
import repackage.org.w3c.dom.NodeList;

public class FnIDREF
extends Function {
    private static Collection _expected_args = null;

    public FnIDREF() {
        super(new QName("idref"), 1, 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnIDREF.idref(args, this.dynamic_context());
    }

    public static ResultSequence idref(Collection args, DynamicContext context) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnIDREF.expected_args());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idst = idrefRS.first().string_value().split(" ");
        ArrayList ids = FnIDREF.createIDs(idst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (context.context_item() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(context.context_item() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)context.context_item();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnIDREF.hasID(ids, node)) {
            ElementType element = new ElementType((Element)node);
            rs.add(element);
        }
        rs = FnIDREF.processAttributes(node, ids, rs);
        rs = FnIDREF.processChildNodes(node, ids, rs);
        return rs;
    }

    private static ArrayList createIDs(String[] idtokens) {
        ArrayList<XSID> xsid = new ArrayList<XSID>();
        int i = 0;
        while (i < idtokens.length) {
            XSID id = new XSID(idtokens[i]);
            xsid.add(id);
            ++i;
        }
        return xsid;
    }

    private static ResultSequence processChildNodes(Node node, List ids, ResultSequence rs) {
        if (!node.hasChildNodes()) {
            return rs;
        }
        NodeList nodeList = node.getChildNodes();
        int nodecnt = 0;
        while (nodecnt < nodeList.getLength()) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() == 1 && !FnIDREF.isDuplicate(childNode, rs)) {
                ElementType element = new ElementType((Element)childNode);
                if (element.isIDREF() && FnIDREF.hasID(ids, childNode)) {
                    rs.add(element);
                }
                rs = FnIDREF.processAttributes(childNode, ids, rs);
                rs = FnIDREF.processChildNodes(childNode, ids, rs);
            }
            ++nodecnt;
        }
        return rs;
    }

    private static ResultSequence processAttributes(Node node, List idrefs, ResultSequence rs) {
        if (!node.hasAttributes()) {
            return rs;
        }
        NamedNodeMap attributeList = node.getAttributes();
        int atsub = 0;
        while (atsub < attributeList.getLength()) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode);
            if (((NodeType)atType).isID() && FnIDREF.hasID(idrefs, atNode) && !FnIDREF.isDuplicate(node, rs)) {
                ElementType element = new ElementType((Element)node);
                rs.add(element);
            }
            ++atsub;
        }
        return rs;
    }

    private static boolean hasID(List ids, Node node) {
        int i = 0;
        while (i < ids.size()) {
            XSID idref = (XSID)ids.get(i);
            if (idref.string_value().equals(node.getNodeValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultSequence rs) {
        ListIterator it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

