/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import repackage.javax.xml.datatype.DatatypeConfigurationException;
import repackage.javax.xml.datatype.DatatypeFactory;
import repackage.javax.xml.datatype.Duration;
import repackage.javax.xml.datatype.XMLGregorianCalendar;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.DynamicError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import repackage.org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;

public class FnAdjustDateToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustDateToTimeZone() {
        super(new QName("adjust-date-to-timezone"), 1, 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnAdjustDateToTimeZone.adjustDate(args, this.dynamic_context());
    }

    public static ResultSequence adjustDate(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustDateToTimeZone.expectedArgs());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return rs;
        }
        ResultSequence arg2 = ResultSequenceFactory.create_new();
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSDate date = (XSDate)arg1.first();
        XSDayTimeDuration timezone = null;
        if (arg2.empty()) {
            if (date.timezoned()) {
                XSDate localized = new XSDate(date.calendar(), null);
                rs.add(localized);
                return rs;
            }
            return arg1;
        }
        timezone = (XSDayTimeDuration)arg2.first();
        if (timezone.lt(minDuration, dc) || timezone.gt(maxDuration, dc)) {
            throw DynamicError.invalidTimezone();
        }
        if (date.tz() == null) {
            rs.add(new XSDate(date.calendar(), timezone));
            return rs;
        }
        try {
            XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)date.normalizeCalendar(date.calendar(), date.tz()));
            Duration duration = DatatypeFactory.newInstance().newDuration(timezone.string_value());
            xmlCalendar.add(duration);
            rs.add(new XSDate(xmlCalendar.toGregorianCalendar(), timezone));
        }
        catch (DatatypeConfigurationException ex) {
            throw DynamicError.invalidTimezone();
        }
        return rs;
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDate(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

