/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor;

import java.util.Collection;
import java.util.Iterator;
import repackage.org.eclipse.wst.xml.xpath2.processor.StaticChecker;
import repackage.org.eclipse.wst.xml.xpath2.processor.StaticContext;
import repackage.org.eclipse.wst.xml.xpath2.processor.StaticError;
import repackage.org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticAttrNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticElemNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticFunctNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticNsNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticTypeNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.StaticVarNameError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.NodeTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.UnExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class StaticNameResolver
implements XPathVisitor,
StaticChecker {
    private StaticContext _sc;
    private StaticNameError _err;

    public StaticNameResolver(StaticContext sc) {
        this._sc = sc;
        this._err = null;
    }

    private void report_error(StaticNameError err) {
        this._err = err;
        throw new DummyError();
    }

    private void report_bad_prefix(String prefix) {
        this.report_error(StaticNsNameError.unknown_prefix(prefix));
    }

    public void check(XPathNode node) throws StaticError {
        try {
            node.accept(this);
        }
        catch (DummyError e) {
            throw this._err;
        }
    }

    public Object visit(XPath xp) {
        Iterator i = xp.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
        return null;
    }

    private void doForExpr(Iterator iter, Expr expr) {
        int scopes = 0;
        while (iter.hasNext()) {
            VarExprPair pair = (VarExprPair)iter.next();
            QName var = pair.varname();
            if (!this._sc.expand_qname(var)) {
                this.report_bad_prefix(var.prefix());
            }
            Expr e = pair.expr();
            e.accept(this);
            this._sc.new_scope();
            ++scopes;
            this._sc.add_variable(var);
        }
        this._sc.new_scope();
        ++scopes;
        expr.accept(this);
        int i = 0;
        while (i < scopes) {
            this._sc.destroy_scope();
            ++i;
        }
    }

    public Object visit(ForExpr fex) {
        this.doForExpr(fex.iterator(), fex.expr());
        return null;
    }

    public Object visit(QuantifiedExpr qex) {
        this.doForExpr(qex.iterator(), qex.expr());
        return null;
    }

    private void printExprs(Iterator i) {
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            e.accept(this);
        }
    }

    public Object visit(IfExpr ifex) {
        this.printExprs(ifex.iterator());
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return null;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    public Object visit(OrExpr orex) {
        this.printBinExpr("OR", orex);
        return null;
    }

    public Object visit(AndExpr andex) {
        this.printBinExpr("AND", andex);
        return null;
    }

    public Object visit(CmpExpr cmpex) {
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return null;
    }

    public Object visit(RangeExpr rex) {
        this.printBinExpr("RANGE", rex);
        return null;
    }

    public Object visit(AddExpr addex) {
        this.printBinExpr("ADD", addex);
        return null;
    }

    public Object visit(SubExpr subex) {
        this.printBinExpr("SUB", subex);
        return null;
    }

    public Object visit(MulExpr mulex) {
        this.printBinExpr("MUL", mulex);
        return null;
    }

    public Object visit(DivExpr mulex) {
        this.printBinExpr("DIV", mulex);
        return null;
    }

    public Object visit(IDivExpr mulex) {
        this.printBinExpr("IDIV", mulex);
        return null;
    }

    public Object visit(ModExpr mulex) {
        this.printBinExpr("MOD", mulex);
        return null;
    }

    public Object visit(UnionExpr unex) {
        this.printBinExpr("UNION", unex);
        return null;
    }

    public Object visit(PipeExpr pipex) {
        this.printBinExpr("PIPE", pipex);
        return null;
    }

    public Object visit(IntersectExpr iexpr) {
        this.printBinExpr("INTERSECT", iexpr);
        return null;
    }

    public Object visit(ExceptExpr eexpr) {
        this.printBinExpr("INT_EXCEPT", eexpr);
        return null;
    }

    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return null;
    }

    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return null;
    }

    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return null;
    }

    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        QName type = ((SingleType)cexp.right()).type();
        if (!this._sc.function_exists(type, 1)) {
            this.report_error(new StaticTypeNameError(null));
        }
        return null;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    public Object visit(MinusExpr e) {
        this.printUnExpr("MINUS", e);
        return null;
    }

    public Object visit(PlusExpr e) {
        this.printUnExpr("PLUS", e);
        return null;
    }

    public Object visit(XPathExpr e) {
        XPathExpr xp = e;
        while (xp != null) {
            StepExpr se = xp.expr();
            if (se != null) {
                se.accept(this);
            }
            xp = xp.next();
        }
        return null;
    }

    public Object visit(ForwardStep e) {
        e.node_test().accept(this);
        return null;
    }

    public Object visit(ReverseStep e) {
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        return null;
    }

    public Object visit(NameTest e) {
        QName name = e.name();
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    public Object visit(VarRef e) {
        QName var = e.name();
        if (!this._sc.expand_qname(var)) {
            this.report_bad_prefix(var.prefix());
        }
        if (!this._sc.variable_in_scope(var)) {
            this.report_error(new StaticVarNameError("Variable not in scope: " + var.string()));
        }
        return null;
    }

    public Object visit(StringLiteral e) {
        return null;
    }

    public Object visit(IntegerLiteral e) {
        return null;
    }

    public Object visit(DoubleLiteral e) {
        return null;
    }

    public Object visit(DecimalLiteral e) {
        return null;
    }

    public Object visit(ParExpr e) {
        this.printExprs(e.iterator());
        return null;
    }

    public Object visit(CntxItemExpr e) {
        return null;
    }

    public Object visit(FunctionCall e) {
        QName name = e.name();
        if (!this._sc.expand_function_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if (!this._sc.function_exists(name, e.arity())) {
            this.report_error(new StaticFunctNameError("Function does not exist: " + name.string() + " arity: " + e.arity()));
        }
        this.printExprs(e.iterator());
        return null;
    }

    public Object visit(SingleType e) {
        QName type = e.type();
        if (!this._sc.expand_elem_type_qname(type)) {
            this.report_bad_prefix(type.prefix());
        }
        return null;
    }

    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                QName type = e.qname();
                if (!this._sc.expand_elem_type_qname(type)) {
                    this.report_bad_prefix(type.prefix());
                }
                if (this._sc.type_defined(type) || this._sc.function_exists(type, 1)) break;
                this.report_error(new StaticTypeNameError("Type not defined: " + type.string()));
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return null;
    }

    public Object visit(AnyKindTest e) {
        return null;
    }

    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return null;
    }

    public Object visit(TextTest e) {
        return null;
    }

    public Object visit(CommentTest e) {
        return null;
    }

    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return null;
    }

    public Object visit(AttributeTest e) {
        QName name = e.name();
        if (name == null) {
            return null;
        }
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if ((name = e.type()) == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    public Object visit(SchemaAttrTest e) {
        QName name = e.arg();
        if (!this._sc.expand_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if (!this._sc.attribute_declared(name)) {
            this.report_error(new StaticAttrNameError("Attribute not decleared: " + name.string()));
        }
        return null;
    }

    public Object visit(ElementTest e) {
        QName name = e.name();
        if (name == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        if ((name = e.type()) == null) {
            return null;
        }
        if (!this._sc.expand_elem_type_qname(name)) {
            this.report_bad_prefix(name.prefix());
        }
        return null;
    }

    public Object visit(SchemaElemTest e) {
        QName elem = e.name();
        if (!this._sc.expand_elem_type_qname(elem)) {
            this.report_bad_prefix(elem.prefix());
        }
        if (!this._sc.element_declared(elem)) {
            this.report_error(new StaticElemNameError("Element not declared: " + elem.string()));
        }
        return null;
    }

    private void printCollExprs(Iterator i) {
        while (i.hasNext()) {
            Collection exprs = (Collection)i.next();
            this.printExprs(exprs.iterator());
        }
    }

    public Object visit(AxisStep e) {
        e.step().accept(this);
        this.printCollExprs(e.iterator());
        return null;
    }

    public Object visit(FilterExpr e) {
        e.primary().accept(this);
        this.printCollExprs(e.iterator());
        return null;
    }

    static class DummyError
    extends Error {
        private static final long serialVersionUID = 3898564402981741950L;

        DummyError() {
        }
    }
}

