/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor;

import java.io.StringReader;
import repackage.java_cup.runtime.Symbol;
import repackage.org.eclipse.wst.xml.xpath2.processor.XPathParser;
import repackage.org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import repackage.org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.CupError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.JFlexError;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.XPathCup;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.XPathCupRestricted;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.XPathFlex;

public class JFlexCupParser
implements XPathParser {
    public XPath parse(String xpath) throws XPathParserException {
        XPathFlex lexer2 = new XPathFlex(new StringReader(xpath));
        XPathCup p = new XPathCup(lexer2);
        try {
            Symbol res = p.parse();
            return (XPath)res.value;
        }
        catch (JFlexError e) {
            throw new XPathParserException("JFlex lexer error: " + e.reason());
        }
        catch (CupError e) {
            throw new XPathParserException("CUP parser error: " + e.reason());
        }
        catch (Exception e) {
            String err = "Unknown error at line " + lexer2.lineno();
            err = String.valueOf(err) + " col " + lexer2.colno();
            err = String.valueOf(err) + ": " + lexer2.yytext();
            throw new XPathParserException(err);
        }
    }

    public XPath parse(String xpath, boolean isRootlessAccess) throws XPathParserException {
        XPathFlex lexer2 = new XPathFlex(new StringReader(xpath));
        XPathCup p = null;
        p = isRootlessAccess ? new XPathCupRestricted(lexer2) : new XPathCup(lexer2);
        try {
            Symbol res = p.parse();
            return (XPath)res.value;
        }
        catch (JFlexError e) {
            throw new XPathParserException("JFlex lexer error: " + e.reason());
        }
        catch (CupError e) {
            throw new XPathParserException("CUP parser error: " + e.reason());
        }
        catch (Exception e) {
            throw new XPathParserException(e.getMessage());
        }
    }
}

