/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.eclipse.wst.xml.xpath2.processor;

import repackage.org.eclipse.wst.xml.xpath2.processor.XPathException;
import repackage.org.eclipse.wst.xml.xpath2.processor.internal.TypeError;

public class DynamicError
extends XPathException {
    private static final long serialVersionUID = -6146830764753685791L;
    private String _code;
    private TypeError _te;

    public DynamicError(String code, String err) {
        super(err);
        this._code = code;
        this._te = null;
    }

    public DynamicError(TypeError te) {
        super(te.reason());
        this._te = te;
        this._code = te.code();
    }

    public String code() {
        if (this._te != null) {
            return this._te.code();
        }
        return this._code;
    }

    public static DynamicError cant_cast(String err) {
        String error = "Can't cast to required type.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FORG0001", error);
    }

    public static DynamicError throw_type_error() throws DynamicError {
        throw DynamicError.argument_type_error(null);
    }

    public static DynamicError argument_type_error(Class type) {
        return new DynamicError("FORG0006", type != null ? "Invalid argument type :" + type.getName() : "Invalid argument type");
    }

    public static DynamicError argument_type_error(String typeName) {
        return DynamicError.make_error("FORG0006", "Invalid argument type : " + typeName, null);
    }

    public static DynamicError invalidType() throws DynamicError {
        throw new DynamicError(TypeError.invalid_type(null));
    }

    public static DynamicError inputToLargeForDecimal() throws DynamicError {
        throw new DynamicError("FOCA0001", "Input value too large for decimal");
    }

    public static DynamicError user_error(String ns, String code, String desc) {
        String error = "Error reported by fn:error.";
        if (desc != null) {
            error = String.valueOf(desc) + " (reported by fn:error)";
        }
        return new DynamicError(code, error);
    }

    public static DynamicError user_error(String err) {
        String error = "Error reported by fn:error.";
        if (err != null) {
            error = String.valueOf(err) + " (reported by fn:error)";
        }
        return new DynamicError("FOER0000", error);
    }

    public static DynamicError regex_flags_error(String err) {
        String error = "Invalid regular expression flag parameter.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FORX0001", error);
    }

    public static DynamicError regex_error(String err) {
        String error = "Invalid regular expression.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FORX0002", error);
    }

    public static DynamicError regex_match_zero_length(String err) {
        String error = "Invalid regular expression.";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FORX0003", error);
    }

    public static DynamicError unsupported_codepoint(String err) {
        String error = "Unsupported codepoint";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FOCH0001", error);
    }

    public static DynamicError unsupported_collation(String collationName) {
        String error = "Unsupported collation URI. ";
        if (collationName != null) {
            error = String.valueOf(error) + " " + collationName;
        }
        return new DynamicError("FOCH0002", error);
    }

    public static DynamicError unsupported_normalization_form(String err) {
        String error = "Unsupported normalization form: ";
        if (err != null) {
            error = String.valueOf(error) + " " + err;
        }
        return new DynamicError("FOCH0003", error);
    }

    public static DynamicError runtime_error(String msg, Throwable err) {
        String error = "Error at runtime: " + msg + ": " + err.getMessage();
        return new DynamicError("FOER0000", error);
    }

    private static DynamicError make_error(String code, String err, String msg) {
        String error = err;
        if (msg != null) {
            error = String.valueOf(error) + msg;
        }
        return new DynamicError(code, error);
    }

    public static DynamicError lexical_error(String msg) {
        return DynamicError.make_error("FOCA0002", "Invalid lexical value.", msg);
    }

    public static DynamicError not_cmp(String msg) {
        return DynamicError.make_error("XPDY0021", "Items not comparable", msg);
    }

    public static DynamicError no_typedvalue_for_node(String msg) {
        return DynamicError.make_error("FOTY0012", "the node has no typed value", msg);
    }

    public static DynamicError more_one_item(String msg) {
        return DynamicError.make_error("FORG0003", "fn:zero-or-one called with a sequence containing more than one item", msg);
    }

    public static DynamicError empty_seq(String msg) {
        return DynamicError.make_error("FORG0004", "fn:one-or-more called with a sequence containing no items", msg);
    }

    public static DynamicError not_one(String msg) {
        return DynamicError.make_error("FORG0005", "fn:exactly-one called with a sequence containing zero or more than one item", msg);
    }

    public static DynamicError invalidCollectionArgument() {
        return DynamicError.make_error("FODC0004", "Invalid argument to fn:doc", null);
    }

    public static DynamicError invalid_doc(String msg) {
        return DynamicError.make_error("FODC0005", "Invalid argument to fn:doc", msg);
    }

    public static DynamicError doc_not_found(String msg) {
        return DynamicError.make_error("FODC0002", "Document argument fn:doc not found", msg);
    }

    public static DynamicError div_zero(String msg) {
        return DynamicError.make_error("FOAR0001", "Division by zero", msg);
    }

    public static DynamicError numeric_overflow(String msg) {
        return DynamicError.make_error("FOAR0002", "Numeric overflow/underflow", msg);
    }

    public static DynamicError contextUndefined() {
        return DynamicError.make_error("XPDY0002", "Context is undefined.", "");
    }

    public static DynamicError invalidForCastConstructor() {
        return DynamicError.make_error("FORG0001", "data type invalid for cast or constructor", null);
    }

    public static DynamicError invalidPrefix() {
        return DynamicError.make_error("FONS0004", "No namespace found for prefix.", null);
    }

    public static DynamicError noContextDoc() {
        return DynamicError.make_error("FODC0001", "No context document.", null);
    }

    public static DynamicError noBaseURI() {
        return DynamicError.make_error("FONS0005", "Base-uri not defined in the static context.", null);
    }

    public static DynamicError errorResolvingURI() {
        return DynamicError.make_error("FORG0002", "Invalid argument to fn:resolve-uri().", null);
    }

    public static DynamicError invalidTimezone() {
        return DynamicError.make_error("FODT0003", "Invalid timezone value.", null);
    }

    public static DynamicError overflowUnderflow() {
        return DynamicError.make_error("FODT0002", "Overflow/underflow in duration operation.", null);
    }

    public static DynamicError nan() {
        return DynamicError.make_error("FOCA0005", "NaN supplied as float/double value.", null);
    }

    public static DynamicError invalidLexicalValue() {
        return DynamicError.make_error("FOCA0002", "Invalid lexical value.", null);
    }

    public static DynamicError overflowDateTime() {
        return DynamicError.make_error("FODT0001", "Overflow/underflow in date/time operation", null);
    }

    public static DynamicError inconsistentTimeZone() {
        return DynamicError.make_error("FORG0008", "The two arguments to fn:dateTime have inconsistent timezones", null);
    }
}

