/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.parsers;

import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import repackage.org.apache.xerces.impl.XMLEntityDescription;
import repackage.org.apache.xerces.impl.dtd.XMLDTDProcessor;
import repackage.org.apache.xerces.parsers.SecuritySupport;
import repackage.org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import repackage.org.apache.xerces.util.SecurityManager;
import repackage.org.apache.xerces.util.SymbolTable;
import repackage.org.apache.xerces.xni.Augmentations;
import repackage.org.apache.xerces.xni.XMLDTDHandler;
import repackage.org.apache.xerces.xni.XMLLocator;
import repackage.org.apache.xerces.xni.XMLResourceIdentifier;
import repackage.org.apache.xerces.xni.XMLString;
import repackage.org.apache.xerces.xni.XNIException;
import repackage.org.apache.xerces.xni.grammars.XMLGrammarPool;
import repackage.org.apache.xerces.xni.parser.XMLComponentManager;
import repackage.org.apache.xerces.xni.parser.XMLConfigurationException;
import repackage.org.apache.xerces.xni.parser.XMLDTDFilter;
import repackage.org.apache.xerces.xni.parser.XMLDTDScanner;
import repackage.org.apache.xerces.xni.parser.XMLDTDSource;
import repackage.org.apache.xerces.xni.parser.XMLEntityResolver;
import repackage.org.apache.xerces.xni.parser.XMLInputSource;

public final class SecureProcessingConfiguration
extends XIncludeAwareParserConfiguration {
    private static final String SECURITY_MANAGER_PROPERTY = "http://apache.org/xml/properties/security-manager";
    private static final String ENTITY_RESOLVER_PROPERTY = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final boolean DEBUG = SecureProcessingConfiguration.isDebugEnabled();
    private static Properties jaxpProperties = null;
    private static long lastModified = -1L;
    private static final int SECURITY_MANAGER_DEFAULT_ENTITY_EXPANSION_LIMIT = 100000;
    private static final int SECURITY_MANAGER_DEFAULT_MAX_OCCUR_NODE_LIMIT = 3000;
    private static final String ENTITY_EXPANSION_LIMIT_PROPERTY_NAME = "jdk.xml.entityExpansionLimit";
    private static final String MAX_OCCUR_LIMIT_PROPERTY_NAME = "jdk.xml.maxOccur";
    private static final String TOTAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.totalEntitySizeLimit";
    private static final String MAX_GENERAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.maxGeneralEntitySizeLimit";
    private static final String MAX_PARAMETER_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.maxParameterEntitySizeLimit";
    private static final String RESOLVE_EXTERNAL_ENTITIES_PROPERTY_NAME = "jdk.xml.resolveExternalEntities";
    private static final int ENTITY_EXPANSION_LIMIT_DEFAULT_VALUE = 64000;
    private static final int MAX_OCCUR_LIMIT_DEFAULT_VALUE = 5000;
    private static final int TOTAL_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = 50000000;
    private static final int MAX_GENERAL_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final int MAX_PARAMETER_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final boolean RESOLVE_EXTERNAL_ENTITIES_DEFAULT_VALUE = true;
    protected final int ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE;
    protected final int MAX_OCCUR_LIMIT_SYSTEM_VALUE;
    protected final int TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final int MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final int MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final boolean RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE;
    private final boolean fJavaSecurityManagerEnabled = System.getSecurityManager() != null;
    private boolean fLimitSpecified;
    private SecurityManager fSecurityManager;
    private InternalEntityMonitor fInternalEntityMonitor;
    private final ExternalEntityMonitor fExternalEntityMonitor;
    private int fTotalEntitySize = 0;

    public SecureProcessingConfiguration() {
        this(null, null, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(symbolTable, xMLGrammarPool, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, XMLComponentManager xMLComponentManager) {
        super(symbolTable, xMLGrammarPool, xMLComponentManager);
        this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE = this.getPropertyValue(ENTITY_EXPANSION_LIMIT_PROPERTY_NAME, 64000);
        this.MAX_OCCUR_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_OCCUR_LIMIT_PROPERTY_NAME, 5000);
        this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(TOTAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME, 50000000);
        this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_GENERAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME, Integer.MAX_VALUE);
        this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_PARAMETER_ENTITY_SIZE_LIMIT_PROPERTY_NAME, Integer.MAX_VALUE);
        this.RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE = this.getPropertyValue(RESOLVE_EXTERNAL_ENTITIES_PROPERTY_NAME, true);
        if (this.fJavaSecurityManagerEnabled || this.fLimitSpecified) {
            if (!this.RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE) {
                super.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
                super.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
                super.setFeature(LOAD_EXTERNAL_DTD, false);
            }
            this.fSecurityManager = new SecurityManager();
            this.fSecurityManager.setEntityExpansionLimit(this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE);
            this.fSecurityManager.setMaxOccurNodeLimit(this.MAX_OCCUR_LIMIT_SYSTEM_VALUE);
            super.setProperty(SECURITY_MANAGER_PROPERTY, this.fSecurityManager);
        }
        this.fExternalEntityMonitor = new ExternalEntityMonitor();
        super.setProperty(ENTITY_RESOLVER_PROPERTY, this.fExternalEntityMonitor);
    }

    protected void checkEntitySizeLimits(int n, int n2, boolean bl) {
        this.fTotalEntitySize += n2;
        if (this.fTotalEntitySize > this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "TotalEntitySizeLimitExceeded", new Object[]{new Integer(this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
        }
        if (bl) {
            if (n > this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MaxParameterEntitySizeLimitExceeded", new Object[]{new Integer(this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
            }
        } else if (n > this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MaxGeneralEntitySizeLimitExceeded", new Object[]{new Integer(this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
        }
    }

    public Object getProperty(String string) throws XMLConfigurationException {
        if (SECURITY_MANAGER_PROPERTY.equals(string)) {
            return this.fSecurityManager;
        }
        if (ENTITY_RESOLVER_PROPERTY.equals(string)) {
            return this.fExternalEntityMonitor;
        }
        return super.getProperty(string);
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (SECURITY_MANAGER_PROPERTY.equals(string)) {
            if (object == null && this.fJavaSecurityManagerEnabled) {
                return;
            }
            this.fSecurityManager = (SecurityManager)object;
            if (this.fSecurityManager != null) {
                if (this.fSecurityManager.getEntityExpansionLimit() == 100000) {
                    this.fSecurityManager.setEntityExpansionLimit(this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE);
                }
                if (this.fSecurityManager.getMaxOccurNodeLimit() == 3000) {
                    this.fSecurityManager.setMaxOccurNodeLimit(this.MAX_OCCUR_LIMIT_SYSTEM_VALUE);
                }
            }
        } else if (ENTITY_RESOLVER_PROPERTY.equals(string)) {
            this.fExternalEntityMonitor.setEntityResolver((XMLEntityResolver)object);
            return;
        }
        super.setProperty(string, object);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.configurePipelineCommon(true);
    }

    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configurePipelineCommon(false);
    }

    private void configurePipelineCommon(boolean bl) {
        if (this.fSecurityManager != null) {
            XMLDTDProcessor xMLDTDProcessor;
            XMLDTDScanner xMLDTDScanner;
            this.fTotalEntitySize = 0;
            if (this.fInternalEntityMonitor == null) {
                this.fInternalEntityMonitor = new InternalEntityMonitor();
            }
            if (bl) {
                xMLDTDScanner = this.fDTDScanner;
                xMLDTDProcessor = this.fDTDProcessor;
            } else {
                xMLDTDScanner = this.fXML11DTDScanner;
                xMLDTDProcessor = this.fXML11DTDProcessor;
            }
            xMLDTDScanner.setDTDHandler(this.fInternalEntityMonitor);
            this.fInternalEntityMonitor.setDTDSource(xMLDTDScanner);
            this.fInternalEntityMonitor.setDTDHandler(xMLDTDProcessor);
            xMLDTDProcessor.setDTDSource(this.fInternalEntityMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int getPropertyValue(String var1_1, int var2_2) {
        block39: {
            block36: {
                try {
                    var3_3 = SecuritySupport.getSystemProperty(var1_1);
                    if (var3_3 != null && var3_3.length() > 0) {
                        if (SecureProcessingConfiguration.DEBUG) {
                            SecureProcessingConfiguration.debugPrintln("found system property \"" + var1_1 + "\", value=" + var3_3);
                        }
                        var4_11 = Integer.parseInt(var3_3);
                        this.fLimitSpecified = true;
                        if (var4_11 > 0) {
                            return var4_11;
                        }
                        return 0x7FFFFFFF;
                    }
                }
                catch (VirtualMachineError var3_4) {
                    throw var3_4;
                }
                catch (ThreadDeath var3_5) {
                    throw var3_5;
                }
                catch (Throwable var3_6) {
                    if (!SecureProcessingConfiguration.DEBUG) break block36;
                    SecureProcessingConfiguration.debugPrintln(var3_6.getClass().getName() + ": " + var3_6.getMessage());
                    var3_6.printStackTrace();
                }
            }
            try {
                var3_7 = false;
                var4_12 = null;
                try {
                    var5_13 = SecuritySupport.getSystemProperty("java.home");
                    var6_15 = (String)var5_13 + File.separator + "lib" + File.separator + "jaxp.properties";
                    var4_12 = new File(var6_15);
                    var3_7 = SecuritySupport.getFileExists(var4_12);
                }
                catch (SecurityException var5_14) {
                    SecureProcessingConfiguration.lastModified = -1L;
                    SecureProcessingConfiguration.jaxpProperties = null;
                }
                var5_13 = SecureProcessingConfiguration.class;
                synchronized (var5_13) {
                    block38: {
                        var6_16 = 0;
                        var7_17 = null;
                        try {
                            block37: {
                                if (SecureProcessingConfiguration.lastModified >= 0L) {
                                    if (var3_7 && SecureProcessingConfiguration.lastModified < (SecureProcessingConfiguration.lastModified = SecuritySupport.getLastModified(var4_12))) {
                                        var6_16 = 1;
                                    } else if (!var3_7) {
                                        SecureProcessingConfiguration.lastModified = -1L;
                                        SecureProcessingConfiguration.jaxpProperties = null;
                                    }
                                } else if (var3_7) {
                                    var6_16 = 1;
                                    SecureProcessingConfiguration.lastModified = SecuritySupport.getLastModified(var4_12);
                                }
                                if (var6_16 != true) break block37;
                                SecureProcessingConfiguration.jaxpProperties = new Properties();
                                var7_17 = SecuritySupport.getFileInputStream(var4_12);
                                SecureProcessingConfiguration.jaxpProperties.load(var7_17);
                            }
                            var10_18 = null;
                            ** if (var7_17 == null) goto lbl-1000
                        }
                        catch (Throwable var9_25) {
                            var10_20 = null;
                            if (var7_17 != null) {
                                try {
                                    var7_17.close();
                                }
                                catch (IOException var11_23) {
                                    // empty catch block
                                }
                            }
                            throw var9_25;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var7_17.close();
                            }
                            catch (IOException var11_21) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block38;
                            catch (Exception var8_24) {
                                SecureProcessingConfiguration.lastModified = -1L;
                                SecureProcessingConfiguration.jaxpProperties = null;
                                var10_19 = null;
                                if (var7_17 != null) {
                                    try {
                                        var7_17.close();
                                    }
                                    catch (IOException var11_22) {}
                                }
                            }
                        }
                    }
                }
                if (SecureProcessingConfiguration.jaxpProperties != null && (var5_13 = SecureProcessingConfiguration.jaxpProperties.getProperty(var1_1)) != null && var5_13.length() > 0) {
                    if (SecureProcessingConfiguration.DEBUG) {
                        SecureProcessingConfiguration.debugPrintln("found \"" + var1_1 + "\" in jaxp.properties, value=" + (String)var5_13);
                    }
                    var6_16 = Integer.parseInt((String)var5_13);
                    this.fLimitSpecified = true;
                    if (var6_16 > 0) {
                        return var6_16;
                    }
                    return 0x7FFFFFFF;
                }
            }
            catch (VirtualMachineError var3_8) {
                throw var3_8;
            }
            catch (ThreadDeath var3_9) {
                throw var3_9;
            }
            catch (Throwable var3_10) {
                if (!SecureProcessingConfiguration.DEBUG) break block39;
                SecureProcessingConfiguration.debugPrintln(var3_10.getClass().getName() + ": " + var3_10.getMessage());
                var3_10.printStackTrace();
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean getPropertyValue(String var1_1, boolean var2_2) {
        block37: {
            block34: {
                try {
                    var3_3 = SecuritySupport.getSystemProperty(var1_1);
                    if (var3_3 != null && var3_3.length() > 0) {
                        if (SecureProcessingConfiguration.DEBUG) {
                            SecureProcessingConfiguration.debugPrintln("found system property \"" + var1_1 + "\", value=" + var3_3);
                        }
                        var4_11 = Boolean.valueOf(var3_3);
                        this.fLimitSpecified = true;
                        return var4_11;
                    }
                }
                catch (VirtualMachineError var3_4) {
                    throw var3_4;
                }
                catch (ThreadDeath var3_5) {
                    throw var3_5;
                }
                catch (Throwable var3_6) {
                    if (!SecureProcessingConfiguration.DEBUG) break block34;
                    SecureProcessingConfiguration.debugPrintln(var3_6.getClass().getName() + ": " + var3_6.getMessage());
                    var3_6.printStackTrace();
                }
            }
            try {
                var3_7 = false;
                var4_12 = null;
                try {
                    var5_13 = SecuritySupport.getSystemProperty("java.home");
                    var6_15 = (String)var5_13 + File.separator + "lib" + File.separator + "jaxp.properties";
                    var4_12 = new File(var6_15);
                    var3_7 = SecuritySupport.getFileExists(var4_12);
                }
                catch (SecurityException var5_14) {
                    SecureProcessingConfiguration.lastModified = -1L;
                    SecureProcessingConfiguration.jaxpProperties = null;
                }
                var5_13 = SecureProcessingConfiguration.class;
                synchronized (var5_13) {
                    block36: {
                        var6_16 = false;
                        var7_17 = null;
                        try {
                            block35: {
                                if (SecureProcessingConfiguration.lastModified >= 0L) {
                                    if (var3_7 && SecureProcessingConfiguration.lastModified < (SecureProcessingConfiguration.lastModified = SecuritySupport.getLastModified(var4_12))) {
                                        var6_16 = true;
                                    } else if (!var3_7) {
                                        SecureProcessingConfiguration.lastModified = -1L;
                                        SecureProcessingConfiguration.jaxpProperties = null;
                                    }
                                } else if (var3_7) {
                                    var6_16 = true;
                                    SecureProcessingConfiguration.lastModified = SecuritySupport.getLastModified(var4_12);
                                }
                                if (!var6_16) break block35;
                                SecureProcessingConfiguration.jaxpProperties = new Properties();
                                var7_17 = SecuritySupport.getFileInputStream(var4_12);
                                SecureProcessingConfiguration.jaxpProperties.load(var7_17);
                            }
                            var10_18 = null;
                            ** if (var7_17 == null) goto lbl-1000
                        }
                        catch (Throwable var9_25) {
                            var10_20 = null;
                            if (var7_17 != null) {
                                try {
                                    var7_17.close();
                                }
                                catch (IOException var11_23) {
                                    // empty catch block
                                }
                            }
                            throw var9_25;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var7_17.close();
                            }
                            catch (IOException var11_21) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block36;
                            catch (Exception var8_24) {
                                SecureProcessingConfiguration.lastModified = -1L;
                                SecureProcessingConfiguration.jaxpProperties = null;
                                var10_19 = null;
                                if (var7_17 != null) {
                                    try {
                                        var7_17.close();
                                    }
                                    catch (IOException var11_22) {}
                                }
                            }
                        }
                    }
                }
                if (SecureProcessingConfiguration.jaxpProperties != null && (var5_13 = SecureProcessingConfiguration.jaxpProperties.getProperty(var1_1)) != null && var5_13.length() > 0) {
                    if (SecureProcessingConfiguration.DEBUG) {
                        SecureProcessingConfiguration.debugPrintln("found \"" + var1_1 + "\" in jaxp.properties, value=" + (String)var5_13);
                    }
                    var6_16 = Boolean.valueOf((String)var5_13);
                    this.fLimitSpecified = true;
                    return var6_16;
                }
            }
            catch (VirtualMachineError var3_8) {
                throw var3_8;
            }
            catch (ThreadDeath var3_9) {
                throw var3_9;
            }
            catch (Throwable var3_10) {
                if (!SecureProcessingConfiguration.DEBUG) break block37;
                SecureProcessingConfiguration.debugPrintln(var3_10.getClass().getName() + ": " + var3_10.getMessage());
                var3_10.printStackTrace();
            }
        }
        return var2_2;
    }

    private static boolean isDebugEnabled() {
        try {
            String string = SecuritySupport.getSystemProperty("xerces.debug");
            return string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void debugPrintln(String string) {
        if (DEBUG) {
            System.err.println("XERCES: " + string);
        }
    }

    final class ExternalEntityMonitor
    implements XMLEntityResolver {
        private XMLEntityResolver fEntityResolver;

        ExternalEntityMonitor() {
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
            XMLInputSource xMLInputSource = null;
            if (this.fEntityResolver != null) {
                xMLInputSource = this.fEntityResolver.resolveEntity(xMLResourceIdentifier);
            }
            if (SecureProcessingConfiguration.this.fSecurityManager != null && xMLResourceIdentifier instanceof XMLEntityDescription) {
                String string;
                Object object;
                Object object2;
                boolean bl;
                String string2 = ((XMLEntityDescription)xMLResourceIdentifier).getEntityName();
                boolean bl2 = bl = string2 != null && string2.startsWith("%");
                if (xMLInputSource == null) {
                    object2 = xMLResourceIdentifier.getPublicId();
                    object = xMLResourceIdentifier.getExpandedSystemId();
                    string = xMLResourceIdentifier.getBaseSystemId();
                    xMLInputSource = new XMLInputSource((String)object2, (String)object, string);
                }
                if ((object2 = xMLInputSource.getCharacterStream()) != null) {
                    xMLInputSource.setCharacterStream(new ReaderMonitor((Reader)object2, bl));
                } else {
                    object = xMLInputSource.getByteStream();
                    if (object != null) {
                        xMLInputSource.setByteStream(new InputStreamMonitor((InputStream)object, bl));
                    } else {
                        string = xMLResourceIdentifier.getExpandedSystemId();
                        URL uRL = new URL(string);
                        object = uRL.openStream();
                        xMLInputSource.setByteStream(new InputStreamMonitor((InputStream)object, bl));
                    }
                }
            }
            return xMLInputSource;
        }

        public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
            this.fEntityResolver = xMLEntityResolver;
        }

        public XMLEntityResolver getEntityResolver() {
            return this.fEntityResolver;
        }

        final class ReaderMonitor
        extends FilterReader {
            private final boolean isPE;
            private int size;

            protected ReaderMonitor(Reader reader, boolean bl) {
                super(reader);
                this.size = 0;
                this.isPE = bl;
            }

            public int read() throws IOException {
                int n = super.read();
                if (n != -1) {
                    ++this.size;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, 1, this.isPE);
                }
                return n;
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3 = super.read(cArray, n, n2);
                if (n3 > 0) {
                    this.size += n3;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, n3, this.isPE);
                }
                return n3;
            }
        }

        final class InputStreamMonitor
        extends FilterInputStream {
            private final boolean isPE;
            private int size;

            protected InputStreamMonitor(InputStream inputStream, boolean bl) {
                super(inputStream);
                this.size = 0;
                this.isPE = bl;
            }

            public int read() throws IOException {
                int n = super.read();
                if (n != -1) {
                    ++this.size;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, 1, this.isPE);
                }
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 > 0) {
                    this.size += n3;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, n3, this.isPE);
                }
                return n3;
            }
        }
    }

    final class InternalEntityMonitor
    implements XMLDTDFilter {
        private XMLDTDSource fDTDSource;
        private XMLDTDHandler fDTDHandler;

        public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startDTD(xMLLocator, augmentations);
            }
        }

        public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startParameterEntity(string, xMLResourceIdentifier, string2, augmentations);
            }
        }

        public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.textDecl(string, string2, augmentations);
            }
        }

        public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endParameterEntity(string, augmentations);
            }
        }

        public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startExternalSubset(xMLResourceIdentifier, augmentations);
            }
        }

        public void endExternalSubset(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endExternalSubset(augmentations);
            }
        }

        public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.comment(xMLString, augmentations);
            }
        }

        public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.processingInstruction(string, xMLString, augmentations);
            }
        }

        public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.elementDecl(string, string2, augmentations);
            }
        }

        public void startAttlist(String string, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startAttlist(string, augmentations);
            }
        }

        public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.attributeDecl(string, string2, string3, stringArray, string4, xMLString, xMLString2, augmentations);
            }
        }

        public void endAttlist(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endAttlist(augmentations);
            }
        }

        public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
            SecureProcessingConfiguration.this.checkEntitySizeLimits(xMLString.length, xMLString.length, string != null && string.startsWith("%"));
            if (this.fDTDHandler != null) {
                this.fDTDHandler.internalEntityDecl(string, xMLString, xMLString2, augmentations);
            }
        }

        public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.externalEntityDecl(string, xMLResourceIdentifier, augmentations);
            }
        }

        public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(string, xMLResourceIdentifier, string2, augmentations);
            }
        }

        public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(string, xMLResourceIdentifier, augmentations);
            }
        }

        public void startConditional(short s, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startConditional(s, augmentations);
            }
        }

        public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.ignoredCharacters(xMLString, augmentations);
            }
        }

        public void endConditional(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endConditional(augmentations);
            }
        }

        public void endDTD(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD(augmentations);
            }
        }

        public void setDTDSource(XMLDTDSource xMLDTDSource) {
            this.fDTDSource = xMLDTDSource;
        }

        public XMLDTDSource getDTDSource() {
            return this.fDTDSource;
        }

        public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
            this.fDTDHandler = xMLDTDHandler;
        }

        public XMLDTDHandler getDTDHandler() {
            return this.fDTDHandler;
        }
    }
}

