/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import repackage.javax.xml.stream.XMLEventReader;
import repackage.javax.xml.transform.Source;
import repackage.javax.xml.transform.dom.DOMSource;
import repackage.javax.xml.transform.sax.SAXSource;
import repackage.javax.xml.transform.stax.StAXSource;
import repackage.javax.xml.transform.stream.StreamSource;
import repackage.javax.xml.validation.Schema;
import repackage.javax.xml.validation.SchemaFactory;
import repackage.org.apache.xerces.impl.xs.XMLSchemaLoader;
import repackage.org.apache.xerces.jaxp.validation.AbstractXMLSchema;
import repackage.org.apache.xerces.jaxp.validation.DraconianErrorHandler;
import repackage.org.apache.xerces.jaxp.validation.EmptyXMLSchema;
import repackage.org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import repackage.org.apache.xerces.jaxp.validation.ReadOnlyGrammarPool;
import repackage.org.apache.xerces.jaxp.validation.SimpleXMLSchema;
import repackage.org.apache.xerces.jaxp.validation.Util;
import repackage.org.apache.xerces.jaxp.validation.WeakReferenceXMLSchema;
import repackage.org.apache.xerces.jaxp.validation.XMLSchema;
import repackage.org.apache.xerces.util.DOMEntityResolverWrapper;
import repackage.org.apache.xerces.util.DOMInputSource;
import repackage.org.apache.xerces.util.ErrorHandlerWrapper;
import repackage.org.apache.xerces.util.SAXInputSource;
import repackage.org.apache.xerces.util.SAXMessageFormatter;
import repackage.org.apache.xerces.util.SecurityManager;
import repackage.org.apache.xerces.util.StAXInputSource;
import repackage.org.apache.xerces.util.XMLGrammarPoolImpl;
import repackage.org.apache.xerces.xni.XNIException;
import repackage.org.apache.xerces.xni.grammars.Grammar;
import repackage.org.apache.xerces.xni.grammars.XMLGrammarDescription;
import repackage.org.apache.xerces.xni.grammars.XMLGrammarPool;
import repackage.org.apache.xerces.xni.parser.XMLConfigurationException;
import repackage.org.apache.xerces.xni.parser.XMLInputSource;
import repackage.org.w3c.dom.Node;
import repackage.org.w3c.dom.ls.LSResourceResolver;
import repackage.org.xml.sax.ErrorHandler;
import repackage.org.xml.sax.InputSource;
import repackage.org.xml.sax.SAXException;
import repackage.org.xml.sax.SAXNotRecognizedException;
import repackage.org.xml.sax.SAXNotSupportedException;
import repackage.org.xml.sax.SAXParseException;

abstract class BaseSchemaFactory
extends SchemaFactory {
    private static final String JAXP_SOURCE_FEATURE_PREFIX = "http://javax.xml.transform";
    private static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String XML_SCHEMA_VERSION = "http://apache.org/xml/properties/validation/schema/version";
    private final XMLSchemaLoader fXMLSchemaLoader = new XMLSchemaLoader();
    private ErrorHandler fErrorHandler;
    private LSResourceResolver fLSResourceResolver;
    private final DOMEntityResolverWrapper fDOMEntityResolverWrapper;
    private final ErrorHandlerWrapper fErrorHandlerWrapper = new ErrorHandlerWrapper(DraconianErrorHandler.getInstance());
    private SecurityManager fSecurityManager;
    private final XMLGrammarPoolWrapper fXMLGrammarPoolWrapper;
    private boolean fUseGrammarPoolOnly;
    private final String fXSDVersion;

    BaseSchemaFactory(String string) {
        this.fDOMEntityResolverWrapper = new DOMEntityResolverWrapper();
        this.fXMLGrammarPoolWrapper = new XMLGrammarPoolWrapper();
        this.fXMLSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, true);
        this.fXMLSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fXMLGrammarPoolWrapper);
        this.fXMLSchemaLoader.setProperty(XML_SCHEMA_VERSION, string);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
        this.fXSDVersion = string;
        this.fUseGrammarPoolOnly = true;
    }

    public LSResourceResolver getResourceResolver() {
        return this.fLSResourceResolver;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.fLSResourceResolver = lSResourceResolver;
        this.fDOMEntityResolverWrapper.setEntityResolver(lSResourceResolver);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
        this.fErrorHandlerWrapper.setErrorHandler(errorHandler != null ? errorHandler : DraconianErrorHandler.getInstance());
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
    }

    public Schema newSchema(Source[] sourceArray) throws SAXException {
        Source source;
        Object object;
        int n;
        XMLGrammarPoolImplExtension xMLGrammarPoolImplExtension = new XMLGrammarPoolImplExtension();
        this.fXMLGrammarPoolWrapper.setGrammarPool(xMLGrammarPoolImplExtension);
        XMLInputSource[] xMLInputSourceArray = new XMLInputSource[sourceArray.length];
        for (n = 0; n < sourceArray.length; ++n) {
            String string;
            Object object2;
            object = sourceArray[n];
            if (object instanceof StreamSource) {
                source = (StreamSource)object;
                object2 = ((StreamSource)source).getPublicId();
                string = ((StreamSource)source).getSystemId();
                InputStream inputStream = ((StreamSource)source).getInputStream();
                Reader reader = ((StreamSource)source).getReader();
                XMLInputSource xMLInputSource = new XMLInputSource((String)object2, string, null);
                xMLInputSource.setByteStream(inputStream);
                xMLInputSource.setCharacterStream(reader);
                xMLInputSourceArray[n] = xMLInputSource;
                continue;
            }
            if (object instanceof SAXSource) {
                source = (SAXSource)object;
                object2 = ((SAXSource)source).getInputSource();
                if (object2 == null) {
                    throw new SAXException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "SAXSourceNullInputSource", null));
                }
                xMLInputSourceArray[n] = new SAXInputSource(((SAXSource)source).getXMLReader(), (InputSource)object2);
                continue;
            }
            if (object instanceof DOMSource) {
                source = (DOMSource)object;
                object2 = ((DOMSource)source).getNode();
                string = ((DOMSource)source).getSystemId();
                xMLInputSourceArray[n] = new DOMInputSource((Node)object2, string);
                continue;
            }
            if (object instanceof StAXSource) {
                source = (StAXSource)object;
                object2 = ((StAXSource)source).getXMLEventReader();
                if (object2 != null) {
                    xMLInputSourceArray[n] = new StAXInputSource((XMLEventReader)object2);
                    continue;
                }
                xMLInputSourceArray[n] = new StAXInputSource(((StAXSource)source).getXMLStreamReader());
                continue;
            }
            if (object == null) {
                throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "SchemaSourceArrayMemberNull", null));
            }
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "SchemaFactorySourceUnrecognized", new Object[]{object.getClass().getName()}));
        }
        try {
            this.fXMLSchemaLoader.loadGrammar(xMLInputSourceArray);
        }
        catch (XNIException xNIException) {
            throw Util.toSAXException(xNIException);
        }
        catch (IOException iOException) {
            object = new SAXParseException(iOException.getMessage(), null, iOException);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.error((SAXParseException)object);
            }
            throw object;
        }
        this.fXMLGrammarPoolWrapper.setGrammarPool(null);
        n = xMLGrammarPoolImplExtension.getGrammarCount();
        object = null;
        if (this.fUseGrammarPoolOnly) {
            if (n > 1) {
                object = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension), this.fXSDVersion);
            } else if (n == 1) {
                source = xMLGrammarPoolImplExtension.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                object = new SimpleXMLSchema((Grammar)((Object)source[0]), this.fXSDVersion);
            } else {
                object = new EmptyXMLSchema(this.fXSDVersion);
            }
        } else {
            object = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension), false, this.fXSDVersion);
        }
        this.propagateFeatures((AbstractXMLSchema)object);
        return object;
    }

    public Schema newSchema() throws SAXException {
        WeakReferenceXMLSchema weakReferenceXMLSchema = new WeakReferenceXMLSchema(this.fXSDVersion);
        this.propagateFeatures(weakReferenceXMLSchema);
        return weakReferenceXMLSchema;
    }

    public Schema newSchema(XMLGrammarPool xMLGrammarPool) throws SAXException {
        XMLSchema xMLSchema = this.fUseGrammarPoolOnly ? new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPool), this.fXSDVersion) : new XMLSchema(xMLGrammarPool, false, this.fXSDVersion);
        this.propagateFeatures(xMLSchema);
        return xMLSchema;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "FeatureNameNull", null));
        }
        if (string.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string.equals("http://javax.xml.transform.stream.StreamSource/feature") || string.equals("http://javax.xml.transform.sax.SAXSource/feature") || string.equals("http://javax.xml.transform.dom.DOMSource/feature") || string.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            return true;
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecurityManager != null;
        }
        if (string.equals(USE_GRAMMAR_POOL_ONLY)) {
            return this.fUseGrammarPoolOnly;
        }
        try {
            return this.fXMLSchemaLoader.getFeature(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.getLocale(), "feature-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "feature-not-supported", new Object[]{string2}));
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "ProperyNameNull", null));
        }
        if (string.equals(SECURITY_MANAGER)) {
            return this.fSecurityManager;
        }
        if (string.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-supported", new Object[]{string}));
        }
        if (string.equals(XML_SCHEMA_VERSION)) {
            return this.fXSDVersion;
        }
        try {
            return this.fXMLSchemaLoader.getProperty(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-supported", new Object[]{string2}));
        }
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "FeatureNameNull", null));
        }
        if (string.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string.equals("http://javax.xml.transform.stream.StreamSource/feature") || string.equals("http://javax.xml.transform.sax.SAXSource/feature") || string.equals("http://javax.xml.transform.dom.DOMSource/feature") || string.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "feature-read-only", new Object[]{string}));
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.fSecurityManager = bl ? new SecurityManager() : null;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string.equals(USE_GRAMMAR_POOL_ONLY)) {
            this.fUseGrammarPoolOnly = bl;
            return;
        }
        try {
            this.fXMLSchemaLoader.setFeature(string, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.getLocale(), "feature-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "feature-not-supported", new Object[]{string2}));
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.getLocale(), "ProperyNameNull", null));
        }
        if (string.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)object;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-supported", new Object[]{string}));
        }
        if (string.equals(XML_SCHEMA_VERSION)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-read-only", new Object[]{string}));
        }
        try {
            this.fXMLSchemaLoader.setProperty(string, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.getLocale(), "property-not-supported", new Object[]{string2}));
        }
    }

    protected Locale getLocale() {
        return this.fXMLSchemaLoader.getLocale();
    }

    private void propagateFeatures(AbstractXMLSchema abstractXMLSchema) {
        abstractXMLSchema.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.fSecurityManager != null);
        String[] stringArray = this.fXMLSchemaLoader.getRecognizedFeatures();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = this.fXMLSchemaLoader.getFeature(stringArray[i]);
            abstractXMLSchema.setFeature(stringArray[i], bl);
        }
    }

    static class XMLGrammarPoolWrapper
    implements XMLGrammarPool {
        private XMLGrammarPool fGrammarPool;

        XMLGrammarPoolWrapper() {
        }

        public Grammar[] retrieveInitialGrammarSet(String string) {
            return this.fGrammarPool.retrieveInitialGrammarSet(string);
        }

        public void cacheGrammars(String string, Grammar[] grammarArray) {
            this.fGrammarPool.cacheGrammars(string, grammarArray);
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.fGrammarPool.retrieveGrammar(xMLGrammarDescription);
        }

        public void lockPool() {
            this.fGrammarPool.lockPool();
        }

        public void unlockPool() {
            this.fGrammarPool.unlockPool();
        }

        public void clear() {
            this.fGrammarPool.clear();
        }

        void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
            this.fGrammarPool = xMLGrammarPool;
        }

        XMLGrammarPool getGrammarPool() {
            return this.fGrammarPool;
        }
    }

    static class XMLGrammarPoolImplExtension
    extends XMLGrammarPoolImpl {
        public XMLGrammarPoolImplExtension() {
        }

        public XMLGrammarPoolImplExtension(int n) {
            super(n);
        }

        int getGrammarCount() {
            return this.fGrammarCount;
        }
    }
}

