/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xs.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import repackage.javax.xml.namespace.QName;
import repackage.org.apache.xerces.util.SymbolHash;
import repackage.org.apache.xerces.xs.XSNamedMap;
import repackage.org.apache.xerces.xs.XSObject;

public class XSNamedMapImpl
extends AbstractMap
implements XSNamedMap {
    public static final XSNamedMapImpl EMPTY_MAP = new XSNamedMapImpl(new XSObject[0], 0);
    final String[] fNamespaces;
    final int fNSNum;
    final SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    private Set fEntrySet = null;

    public XSNamedMapImpl(String string, SymbolHash symbolHash) {
        this.fNamespaces = new String[]{string};
        this.fMaps = new SymbolHash[]{symbolHash};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] stringArray, SymbolHash[] symbolHashArray, int n) {
        this.fNamespaces = stringArray;
        this.fMaps = symbolHashArray;
        this.fNSNum = n;
    }

    public XSNamedMapImpl(XSObject[] xSObjectArray, int n) {
        if (n == 0) {
            this.fNamespaces = null;
            this.fMaps = null;
            this.fNSNum = 0;
            this.fArray = xSObjectArray;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{xSObjectArray[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = xSObjectArray;
        this.fLength = n;
    }

    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                this.fLength += this.fMaps[i].getLength();
            }
        }
        return this.fLength;
    }

    public XSObject itemByName(String string, String string2) {
        for (int i = 0; i < this.fNSNum; ++i) {
            if (!XSNamedMapImpl.isEqual(string, this.fNamespaces[i])) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i].get(string2);
            }
            for (int j = 0; j < this.fLength; ++j) {
                XSObject xSObject = this.fArray[j];
                if (!xSObject.getName().equals(string2)) continue;
                return xSObject;
            }
            return null;
        }
        return null;
    }

    public synchronized XSObject item(int n) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int n2 = 0;
            for (int i = 0; i < this.fNSNum; ++i) {
                n2 += this.fMaps[i].getValues(this.fArray, n2);
            }
        }
        if (n < 0 || n >= this.fLength) {
            return null;
        }
        return this.fArray[n];
    }

    static boolean isEqual(String string, String string2) {
        return string != null ? string.equals(string2) : string2 == null;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        if (object instanceof QName) {
            QName qName = (QName)object;
            String string = qName.getNamespaceURI();
            if ("".equals(string)) {
                string = null;
            }
            String string2 = qName.getLocalPart();
            return this.itemByName(string, string2);
        }
        return null;
    }

    public int size() {
        return this.getLength();
    }

    public synchronized Set entrySet() {
        if (this.fEntrySet == null) {
            final int n = this.getLength();
            final XSNamedMapEntry[] xSNamedMapEntryArray = new XSNamedMapEntry[n];
            for (int i = 0; i < n; ++i) {
                XSObject xSObject = this.item(i);
                xSNamedMapEntryArray[i] = new XSNamedMapEntry(new QName(xSObject.getNamespace(), xSObject.getName()), xSObject);
            }
            this.fEntrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private int index;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.index = 0;
                        }

                        public boolean hasNext() {
                            return this.index < 1.access$000(this.this$1);
                        }

                        public Object next() {
                            if (this.index < 1.access$000(this.this$1)) {
                                return 1.access$100(this.this$1)[this.index++];
                            }
                            throw new NoSuchElementException();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public int size() {
                    return n;
                }

                static /* synthetic */ int access$000(1 var0) {
                    return var0.n;
                }

                static /* synthetic */ XSNamedMapEntry[] access$100(1 var0) {
                    return var0.xSNamedMapEntryArray;
                }
            };
        }
        return this.fEntrySet;
    }

    private static final class XSNamedMapEntry
    implements Map.Entry {
        private final QName key;
        private final XSObject value;

        public XSNamedMapEntry(QName qName, XSObject xSObject) {
            this.key = qName;
            this.value = xSObject;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return (this.key == null ? k == null : this.key.equals(k)) && (this.value == null ? v == null : this.value.equals(v));
            }
            return false;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(this.key));
            stringBuffer.append('=');
            stringBuffer.append(String.valueOf(this.value));
            return stringBuffer.toString();
        }
    }
}

