/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xs.traversers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import repackage.org.apache.xerces.impl.xs.SchemaSymbols;
import repackage.org.apache.xerces.impl.xs.traversers.OverrideTransformException;
import repackage.org.apache.xerces.impl.xs.traversers.OverrideTransformer;
import repackage.org.apache.xerces.impl.xs.traversers.XSDHandler;
import repackage.org.apache.xerces.util.DOMUtil;
import repackage.org.w3c.dom.Element;
import repackage.org.w3c.dom.Node;

public final class OverrideTransformationManager {
    public static final int STATE_INCLUDE = 1;
    public static final int STATE_CONTINUE = 2;
    public static final int STATE_DUPLICATE = 3;
    public static final int STATE_COLLISION = 4;
    private static String[] fGlobalComponentNames = new String[]{SchemaSymbols.ELT_ATTRIBUTEGROUP, SchemaSymbols.ELT_ATTRIBUTE, SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ELT_ELEMENT, SchemaSymbols.ELT_NOTATION, SchemaSymbols.ELT_GROUP};
    private static String[] fCompositeComponentNames = new String[]{SchemaSymbols.ELT_INCLUDE, SchemaSymbols.ELT_OVERRIDE, SchemaSymbols.ELT_REDEFINE};
    private OverrideTransformer fOverrideTransformationHandler;
    private final HashMap fSystemId2ContextMap = new HashMap();
    private int fCurrentState = 1;
    private final XSDHandler fSchemaHandler;

    public OverrideTransformationManager(XSDHandler xSDHandler, OverrideTransformer overrideTransformer) {
        this.fSchemaHandler = xSDHandler;
        this.fOverrideTransformationHandler = overrideTransformer;
    }

    public void reset() {
        this.fCurrentState = 1;
        if (this.fSystemId2ContextMap.size() != 0) {
            this.fSystemId2ContextMap.clear();
        }
    }

    public Element transform(String string, Element element, Element element2) {
        Element element3;
        boolean bl = false;
        try {
            element3 = this.fOverrideTransformationHandler.transform(element, element2);
        }
        catch (OverrideTransformException overrideTransformException) {
            return element2;
        }
        if (element3 != null) {
            bl = true;
        } else {
            element3 = element2;
        }
        String string2 = this.nullToEmptyString(string);
        if (this.checkSchemaDependencies(string2, element, element3, bl)) {
            return element3;
        }
        return null;
    }

    public void addSchemaRoot(String string, Element element) {
        String string2 = this.nullToEmptyString(string);
        this.setDocumentMapForSystemId(string2, this.createDocumentMap(element, DocumentContext.IS_ORIGINAL));
    }

    public void checkSchemaRoot(String string, Element element, Element element2) {
        String string2 = this.nullToEmptyString(string);
        if (this.includeSchemaDependencies(string2, element2, DocumentContext.IS_ORIGINAL)) {
            this.fCurrentState = 1;
            return;
        }
        DocumentContext documentContext = this.getDocumentMapForSystemId(string2);
        Iterator iterator = documentContext.getSchemaArray();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (DocumentContext.IS_ORIGINAL != documentContext.getSchemaState(element3)) continue;
            this.fCurrentState = 3;
            return;
        }
        this.fCurrentState = 4;
        this.fSchemaHandler.reportSchemaError("src-override-collision.1", new Object[]{string, DOMUtil.getLocalName(element)}, element);
    }

    public int getCurrentState() {
        return this.fCurrentState;
    }

    public void setOverrideHandler(OverrideTransformer overrideTransformer) {
        this.fOverrideTransformationHandler = overrideTransformer;
    }

    private DocumentContext createDocumentMap(Element element, Boolean bl) {
        DocumentContext documentContext = new DocumentContext();
        documentContext.addSchemasToArray(element, bl);
        return documentContext;
    }

    public boolean hasGlobalDecl(Element element) {
        return this.hasComponentsTypes(element, fGlobalComponentNames);
    }

    public boolean hasCompositionalDecl(Element element) {
        return this.hasComponentsTypes(element, fCompositeComponentNames);
    }

    private boolean checkSchemaDependencies(String string, Element element, Element element2, boolean bl) {
        Boolean bl2;
        Boolean bl3 = bl2 = bl ? DocumentContext.IS_TRANSFORMED : DocumentContext.IS_ORIGINAL;
        if (this.includeSchemaDependencies(string, element2, bl2)) {
            this.fCurrentState = 1;
            return true;
        }
        boolean bl4 = false;
        DocumentContext documentContext = this.getDocumentMapForSystemId(string);
        Iterator iterator = documentContext.getSchemaArray();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (this.checkDuplicateElements(documentContext, element3, element2, bl2)) {
                this.fCurrentState = 3;
                return false;
            }
            bl4 = true;
        }
        if (bl4) {
            if (!this.hasGlobalDecl(element2)) {
                documentContext.addSchemasToArray(element2);
            } else {
                this.fCurrentState = 4;
                this.fSchemaHandler.reportSchemaError("src-override-collision.2", new Object[]{string}, element);
                return false;
            }
        }
        this.fCurrentState = 2;
        return true;
    }

    private boolean includeSchemaDependencies(String string, Element element, Boolean bl) {
        if (!this.isSchemaAlreadyTraversed(string)) {
            this.setDocumentMapForSystemId(string, this.createDocumentMap(element, bl));
            return true;
        }
        return false;
    }

    private boolean isSchemaAlreadyTraversed(String string) {
        return this.fSystemId2ContextMap.get(string) != null;
    }

    private boolean checkDuplicateElements(DocumentContext documentContext, Element element, Element element2, Boolean bl) {
        Boolean bl2 = documentContext.getSchemaState(element);
        if (bl2 == DocumentContext.IS_TRANSFORMED && bl == DocumentContext.IS_TRANSFORMED) {
            return this.compareComponents(element, element2);
        }
        return bl2 == DocumentContext.IS_ORIGINAL && bl == DocumentContext.IS_ORIGINAL;
    }

    private boolean compareComponents(Element element, Element element2) {
        element.normalize();
        element2.normalize();
        return element.isEqualNode(element2);
    }

    private DocumentContext getDocumentMapForSystemId(String string) {
        return (DocumentContext)this.fSystemId2ContextMap.get(string);
    }

    private void setDocumentMapForSystemId(String string, DocumentContext documentContext) {
        this.fSystemId2ContextMap.put(string, documentContext);
    }

    private String nullToEmptyString(String string) {
        return string == null ? "" : string;
    }

    private boolean hasComponentsTypes(Element element, String[] stringArray) {
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = this.getLocalName(element2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        return false;
    }

    private String getLocalName(Node node) {
        String string = "";
        string = DOMUtil.getLocalName(node);
        if (string.indexOf(":") > -1) {
            return string.split(":")[1];
        }
        return string;
    }

    private static final class DocumentContext {
        private final ArrayList fRootElementList = new ArrayList();
        private final HashMap fSchema2StateMap = new HashMap();
        private static final Boolean IS_ORIGINAL = Boolean.TRUE;
        private static final Boolean IS_TRANSFORMED = Boolean.FALSE;

        DocumentContext() {
        }

        void addSchemasToArray(Element element) {
            this.fRootElementList.add(element);
        }

        void addSchemasToArray(Element element, Boolean bl) {
            this.addSchemasToArray(element);
            this.fSchema2StateMap.put(element, bl);
        }

        Boolean getSchemaState(Element element) {
            return (Boolean)this.fSchema2StateMap.get(element);
        }

        Iterator getSchemaArray() {
            return this.fRootElementList.iterator();
        }

        void clear() {
            this.fRootElementList.clear();
            this.fSchema2StateMap.clear();
        }
    }
}

