/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xs.opti;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import repackage.org.apache.xerces.impl.XMLErrorReporter;
import repackage.org.apache.xerces.impl.xs.SchemaSymbols;
import repackage.org.apache.xerces.impl.xs.opti.DefaultXMLDocumentHandler;
import repackage.org.apache.xerces.impl.xs.opti.ElementImpl;
import repackage.org.apache.xerces.impl.xs.opti.SchemaConditionalIncludeHelper;
import repackage.org.apache.xerces.impl.xs.opti.SchemaDOM;
import repackage.org.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import repackage.org.apache.xerces.impl.xs.util.XS11TypeHelper;
import repackage.org.apache.xerces.util.XMLAttributesImpl;
import repackage.org.apache.xerces.util.XMLChar;
import repackage.org.apache.xerces.xni.Augmentations;
import repackage.org.apache.xerces.xni.NamespaceContext;
import repackage.org.apache.xerces.xni.QName;
import repackage.org.apache.xerces.xni.XMLAttributes;
import repackage.org.apache.xerces.xni.XMLLocator;
import repackage.org.apache.xerces.xni.XMLString;
import repackage.org.apache.xerces.xni.XNIException;
import repackage.org.apache.xerces.xni.parser.XMLEntityResolver;
import repackage.org.apache.xerces.xni.parser.XMLInputSource;
import repackage.org.apache.xerces.xni.parser.XMLParserConfiguration;
import repackage.org.apache.xerces.xs.datatypes.XSDecimal;
import repackage.org.w3c.dom.Document;

public class SchemaDOMParser
extends DefaultXMLDocumentHandler {
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String GENERATE_SYNTHETIC_ANNOTATION = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected XMLLocator fLocator;
    protected NamespaceContext fNamespaceContext = null;
    SchemaDOM schemaDOM;
    XMLParserConfiguration config;
    private ElementImpl fCurrentAnnotationElement;
    private int fAnnotationDepth = -1;
    private int fInnerAnnotationDepth = -1;
    private int fDepth = -1;
    XMLErrorReporter fErrorReporter;
    private boolean fGenerateSyntheticAnnotation = false;
    private BooleanStack fHasNonSchemaAttributes = new BooleanStack();
    private BooleanStack fSawAnnotation = new BooleanStack();
    private XMLAttributes fEmptyAttr = new XMLAttributesImpl();
    private XSDecimal fSupportedVersion;
    private int fIgnoreDepth = -1;
    private boolean fPerformConditionalInclusion = true;
    private SchemaConditionalIncludeHelper schemaCondlInclHelper = new SchemaConditionalIncludeHelper();

    public SchemaDOMParser(XMLParserConfiguration xMLParserConfiguration) {
        this.config = xMLParserConfiguration;
        xMLParserConfiguration.setDocumentHandler(this);
        xMLParserConfiguration.setDTDHandler(this);
        xMLParserConfiguration.setDTDContentModelHandler(this);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fErrorReporter = (XMLErrorReporter)this.config.getProperty(ERROR_REPORTER);
        this.fGenerateSyntheticAnnotation = this.config.getFeature(GENERATE_SYNTHETIC_ANNOTATION);
        this.fHasNonSchemaAttributes.clear();
        this.fSawAnnotation.clear();
        this.schemaDOM = new SchemaDOM();
        this.fCurrentAnnotationElement = null;
        this.fAnnotationDepth = -1;
        this.fInnerAnnotationDepth = -1;
        this.fDepth = -1;
        this.fIgnoreDepth = -1;
        this.fLocator = xMLLocator;
        this.fNamespaceContext = namespaceContext;
        this.schemaDOM.setDocumentURI(xMLLocator.getExpandedSystemId());
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth > -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.comment(xMLString);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth > -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.processingInstruction(string, xMLString);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fIgnoreDepth > -1) {
            return;
        }
        if (this.fInnerAnnotationDepth == -1) {
            for (int i = xMLString.offset; i < xMLString.offset + xMLString.length; ++i) {
                if (XMLChar.isSpace(xMLString.ch[i])) continue;
                String string = new String(xMLString.ch, i, xMLString.length + xMLString.offset - i);
                this.fErrorReporter.reportError(this.fLocator, "http://www.w3.org/TR/xml-schema-1", "s4s-elt-character", new Object[]{string}, (short)1);
                break;
            }
        } else {
            this.schemaDOM.characters(xMLString);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fDepth;
        if (this.fPerformConditionalInclusion) {
            if (this.fIgnoreDepth > -1) {
                ++this.fIgnoreDepth;
                return;
            }
            if (this.fDepth > -1) {
                this.checkVersionControlAttributes(qName, xMLAttributes);
                if (this.fIgnoreDepth > -1) {
                    return;
                }
            }
        }
        if (this.fAnnotationDepth == -1) {
            if (qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && qName.localpart == SchemaSymbols.ELT_ANNOTATION) {
                if (this.fGenerateSyntheticAnnotation) {
                    if (this.fSawAnnotation.size() > 0) {
                        this.fSawAnnotation.pop();
                    }
                    this.fSawAnnotation.push(true);
                }
                this.fAnnotationDepth = this.fDepth;
                this.schemaDOM.startAnnotation(qName, xMLAttributes, this.fNamespaceContext);
                this.fCurrentAnnotationElement = this.schemaDOM.startElement(qName, xMLAttributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
                return;
            }
            if (qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && this.fGenerateSyntheticAnnotation) {
                this.fSawAnnotation.push(false);
                this.fHasNonSchemaAttributes.push(this.hasNonSchemaAttributes(qName, xMLAttributes));
            }
        } else if (this.fDepth == this.fAnnotationDepth + 1) {
            this.fInnerAnnotationDepth = this.fDepth;
            this.schemaDOM.startAnnotationElement(qName, xMLAttributes);
        } else {
            this.schemaDOM.startAnnotationElement(qName, xMLAttributes);
            return;
        }
        this.schemaDOM.startElement(qName, xMLAttributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fPerformConditionalInclusion) {
            if (this.fIgnoreDepth > -1) {
                return;
            }
            if (this.fDepth > -1) {
                boolean bl = this.checkVersionControlAttributes(qName, xMLAttributes);
                if (this.fIgnoreDepth > -1) {
                    if (bl) {
                        --this.fIgnoreDepth;
                    }
                    return;
                }
            }
        }
        if (this.fGenerateSyntheticAnnotation && this.fAnnotationDepth == -1 && qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && qName.localpart != SchemaSymbols.ELT_ANNOTATION && this.hasNonSchemaAttributes(qName, xMLAttributes)) {
            this.schemaDOM.startElement(qName, xMLAttributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
            xMLAttributes.removeAllAttributes();
            String string = this.fNamespaceContext.getPrefix(SchemaSymbols.URI_SCHEMAFORSCHEMA);
            String string2 = string.length() == 0 ? SchemaSymbols.ELT_ANNOTATION : string + ':' + SchemaSymbols.ELT_ANNOTATION;
            this.schemaDOM.startAnnotation(string2, xMLAttributes, this.fNamespaceContext);
            String string3 = string.length() == 0 ? SchemaSymbols.ELT_DOCUMENTATION : string + ':' + SchemaSymbols.ELT_DOCUMENTATION;
            this.schemaDOM.startAnnotationElement(string3, xMLAttributes);
            this.schemaDOM.charactersRaw("SYNTHETIC_ANNOTATION");
            this.schemaDOM.endSyntheticAnnotationElement(string3, false);
            this.schemaDOM.endSyntheticAnnotationElement(string2, true);
            this.schemaDOM.endElement();
            return;
        }
        if (this.fAnnotationDepth == -1) {
            if (qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && qName.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.startAnnotation(qName, xMLAttributes, this.fNamespaceContext);
            }
        } else {
            this.schemaDOM.startAnnotationElement(qName, xMLAttributes);
        }
        ElementImpl elementImpl = this.schemaDOM.emptyElement(qName, xMLAttributes, this.fLocator.getLineNumber(), this.fLocator.getColumnNumber(), this.fLocator.getCharacterOffset());
        if (this.fAnnotationDepth == -1) {
            if (qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && qName.localpart == SchemaSymbols.ELT_ANNOTATION) {
                this.schemaDOM.endAnnotation(qName, elementImpl);
            }
        } else {
            this.schemaDOM.endAnnotationElement(qName);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fIgnoreDepth == -1) {
            if (this.fAnnotationDepth > -1) {
                if (this.fInnerAnnotationDepth == this.fDepth) {
                    this.fInnerAnnotationDepth = -1;
                    this.schemaDOM.endAnnotationElement(qName);
                    this.schemaDOM.endElement();
                } else if (this.fAnnotationDepth == this.fDepth) {
                    this.fAnnotationDepth = -1;
                    this.schemaDOM.endAnnotation(qName, this.fCurrentAnnotationElement);
                    this.schemaDOM.endElement();
                } else {
                    this.schemaDOM.endAnnotationElement(qName);
                }
            } else {
                if (qName.uri == SchemaSymbols.URI_SCHEMAFORSCHEMA && this.fGenerateSyntheticAnnotation) {
                    boolean bl = this.fHasNonSchemaAttributes.pop();
                    boolean bl2 = this.fSawAnnotation.pop();
                    if (bl && !bl2) {
                        String string = this.fNamespaceContext.getPrefix(SchemaSymbols.URI_SCHEMAFORSCHEMA);
                        String string2 = string.length() == 0 ? SchemaSymbols.ELT_ANNOTATION : string + ':' + SchemaSymbols.ELT_ANNOTATION;
                        this.schemaDOM.startAnnotation(string2, this.fEmptyAttr, this.fNamespaceContext);
                        String string3 = string.length() == 0 ? SchemaSymbols.ELT_DOCUMENTATION : string + ':' + SchemaSymbols.ELT_DOCUMENTATION;
                        this.schemaDOM.startAnnotationElement(string3, this.fEmptyAttr);
                        this.schemaDOM.charactersRaw("SYNTHETIC_ANNOTATION");
                        this.schemaDOM.endSyntheticAnnotationElement(string3, false);
                        this.schemaDOM.endSyntheticAnnotationElement(string2, true);
                    }
                }
                this.schemaDOM.endElement();
            }
        } else {
            --this.fIgnoreDepth;
        }
        --this.fDepth;
    }

    private boolean hasNonSchemaAttributes(QName qName, XMLAttributes xMLAttributes) {
        int n = xMLAttributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = xMLAttributes.getURI(i);
            if (string == null || string == SchemaSymbols.URI_SCHEMAFORSCHEMA || string == NamespaceContext.XMLNS_URI || string == NamespaceContext.XML_URI && xMLAttributes.getQName(i) == SchemaSymbols.ATT_XML_LANG && qName.localpart == SchemaSymbols.ELT_SCHEMA) continue;
            return true;
        }
        return false;
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.characters(xMLString);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.startAnnotationCDATA();
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fAnnotationDepth != -1 && this.fIgnoreDepth == -1) {
            this.schemaDOM.endAnnotationCDATA();
        }
    }

    public Document getDocument() {
        return this.schemaDOM;
    }

    public void setFeature(String string, boolean bl) {
        this.config.setFeature(string, bl);
    }

    public boolean getFeature(String string) {
        return this.config.getFeature(string);
    }

    public void setProperty(String string, Object object) {
        this.config.setProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.config.getProperty(string);
    }

    public void setEntityResolver(XMLEntityResolver xMLEntityResolver) {
        this.config.setEntityResolver(xMLEntityResolver);
    }

    public void parse(XMLInputSource xMLInputSource) throws IOException {
        this.config.parse(xMLInputSource);
    }

    public void reset() {
        ((SchemaParsingConfig)this.config).reset();
    }

    public void resetNodePool() {
        ((SchemaParsingConfig)this.config).resetNodePool();
    }

    public void setSupportedVersion(XSDecimal xSDecimal) {
        this.fSupportedVersion = xSDecimal;
    }

    private boolean checkVersionControlAttributes(QName qName, XMLAttributes xMLAttributes) {
        int n;
        boolean bl = false;
        BigDecimal bigDecimal = null;
        BigDecimal bigDecimal2 = null;
        List list = null;
        List list2 = null;
        List list3 = null;
        List list4 = null;
        for (n = 0; n < xMLAttributes.getLength(); ++n) {
            if (!SchemaSymbols.URI_SCHEMAVERSION.equals(xMLAttributes.getURI(n))) continue;
            String string = xMLAttributes.getLocalName(n);
            String string2 = xMLAttributes.getValue(n);
            if (SchemaSymbols.ATT_MINVERSION.equals(string)) {
                try {
                    bigDecimal = new BigDecimal(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-att-invalid-value", new Object[]{qName.localpart, string, string2}, (short)1);
                }
                continue;
            }
            if (SchemaSymbols.ATT_MAXVERSION.equals(string)) {
                try {
                    bigDecimal2 = new BigDecimal(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "s4s-att-invalid-value", new Object[]{qName.localpart, string, string2}, (short)1);
                }
                continue;
            }
            if (SchemaSymbols.ATT_TYPEAVAILABLE.equals(string)) {
                list = this.tokenizeQNameListString(string2);
                continue;
            }
            if (SchemaSymbols.ATT_TYPEUNAVAILABLE.equals(string)) {
                list2 = this.tokenizeQNameListString(string2);
                continue;
            }
            if (SchemaSymbols.ATT_FACETAVAILABLE.equals(string)) {
                list3 = this.tokenizeQNameListString(string2);
                continue;
            }
            if (SchemaSymbols.ATT_FACETUNAVAILABLE.equals(string)) {
                list4 = this.tokenizeQNameListString(string2);
                continue;
            }
            this.fErrorReporter.reportError(this.fLocator, "http://www.w3.org/TR/xml-schema-1", "src-cip.1", new Object[]{string}, (short)0);
        }
        n = bigDecimal == null && bigDecimal2 == null ? 0 : this.isSchemaLangVersionAllowsExclude(bigDecimal, bigDecimal2);
        boolean bl2 = list == null ? false : this.isTypeAndFacetAvailableAllowsExclude(list, (short)0, (short)2);
        boolean bl3 = list2 == null ? false : this.isTypeAndFacetAvailableAllowsExclude(list2, (short)0, (short)3);
        boolean bl4 = list3 == null ? false : this.isTypeAndFacetAvailableAllowsExclude(list3, (short)1, (short)2);
        boolean bl5 = list4 == null ? false : this.isTypeAndFacetAvailableAllowsExclude(list4, (short)1, (short)3);
        bl = n != 0 || bl2 || bl3 || bl4 || bl5;
        return bl;
    }

    private boolean isSchemaLangVersionAllowsExclude(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        boolean bl = false;
        if (bigDecimal != null && bigDecimal2 != null) {
            if (bigDecimal.compareTo(this.fSupportedVersion.getBigDecimal()) > 0 || bigDecimal2.compareTo(this.fSupportedVersion.getBigDecimal()) != 1) {
                ++this.fIgnoreDepth;
                bl = true;
            }
        } else if (bigDecimal != null && bigDecimal2 == null) {
            if (bigDecimal.compareTo(this.fSupportedVersion.getBigDecimal()) > 0) {
                ++this.fIgnoreDepth;
                bl = true;
            }
        } else if (bigDecimal == null && bigDecimal2 != null && bigDecimal2.compareTo(this.fSupportedVersion.getBigDecimal()) != 1) {
            ++this.fIgnoreDepth;
            bl = true;
        }
        return bl;
    }

    private boolean isTypeAndFacetAvailableAllowsExclude(List list, short s, short s2) {
        boolean bl = false;
        boolean bl2 = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = null;
            String string3 = null;
            if (string.indexOf(58) != -1) {
                string2 = string.substring(string.indexOf(58) + 1);
                String string4 = string.substring(0, string.indexOf(58));
                string3 = this.fNamespaceContext.getURI(string4.intern());
            } else {
                string2 = string;
            }
            if (s == 0) {
                if (s2 == 2 && !this.schemaCondlInclHelper.isTypeSupported(string2, string3)) {
                    bl = true;
                    break;
                }
                if (s2 != 3 || this.schemaCondlInclHelper.isTypeSupported(string2, string3)) continue;
                bl2 = false;
                break;
            }
            if (s != 1) continue;
            if (s2 == 2 && !this.schemaCondlInclHelper.isFacetSupported(string2, string3)) {
                bl = true;
                break;
            }
            if (s2 != 3 || this.schemaCondlInclHelper.isFacetSupported(string2, string3)) continue;
            bl2 = false;
            break;
        }
        if (s2 == 2) {
            if (bl) {
                ++this.fIgnoreDepth;
            }
            return bl;
        }
        if (bl2) {
            ++this.fIgnoreDepth;
        }
        return bl2;
    }

    private List tokenizeQNameListString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
        ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            XS11TypeHelper.validateQNameValue(string2, this.fNamespaceContext, this.fErrorReporter);
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static final class BooleanStack {
        private int fDepth;
        private boolean[] fData;

        public int size() {
            return this.fDepth;
        }

        public void push(boolean bl) {
            this.ensureCapacity(this.fDepth + 1);
            this.fData[this.fDepth++] = bl;
        }

        public boolean pop() {
            return this.fData[--this.fDepth];
        }

        public void clear() {
            this.fDepth = 0;
        }

        private void ensureCapacity(int n) {
            if (this.fData == null) {
                this.fData = new boolean[32];
            } else if (this.fData.length <= n) {
                boolean[] blArray = new boolean[this.fData.length * 2];
                System.arraycopy(this.fData, 0, blArray, 0, this.fData.length);
                this.fData = blArray;
            }
        }
    }
}

