/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Stack;
import repackage.org.apache.xerces.impl.XMLErrorReporter;
import repackage.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import repackage.org.apache.xerces.impl.dv.ValidatedInfo;
import repackage.org.apache.xerces.impl.dv.ValidationContext;
import repackage.org.apache.xerces.impl.dv.XSSimpleType;
import repackage.org.apache.xerces.impl.xs.SchemaGrammar;
import repackage.org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import repackage.org.apache.xerces.impl.xs.XMLSchemaException;
import repackage.org.apache.xerces.impl.xs.XS10Constraints;
import repackage.org.apache.xerces.impl.xs.XS11Constraints;
import repackage.org.apache.xerces.impl.xs.XSComplexTypeDecl;
import repackage.org.apache.xerces.impl.xs.XSElementDecl;
import repackage.org.apache.xerces.impl.xs.XSGrammarBucket;
import repackage.org.apache.xerces.impl.xs.XSGroupDecl;
import repackage.org.apache.xerces.impl.xs.XSModelGroupImpl;
import repackage.org.apache.xerces.impl.xs.XSParticleDecl;
import repackage.org.apache.xerces.impl.xs.XSWildcardDecl;
import repackage.org.apache.xerces.impl.xs.models.CMBuilder;
import repackage.org.apache.xerces.impl.xs.util.SimpleLocator;
import repackage.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import repackage.org.apache.xerces.util.SymbolHash;
import repackage.org.apache.xerces.xs.XSObjectList;
import repackage.org.apache.xerces.xs.XSTerm;
import repackage.org.apache.xerces.xs.XSTypeDefinition;

public abstract class XSConstraints {
    static final int OCCURRENCE_UNKNOWN = -2;
    static final XSSimpleType STRING_TYPE = (XSSimpleType)SchemaGrammar.getS4SGrammar((short)1).getGlobalTypeDecl("string");
    private static XSParticleDecl fEmptyParticle = null;
    static final XSConstraints XS_1_0_CONSTRAINTS = new XS10Constraints(1);
    static final XSConstraints XS_1_0_CONSTRAINTS_EXTENDED = new XS10Constraints(2);
    static final XSConstraints XS_1_1_CONSTRAINTS = new XS11Constraints();
    private final XSComplexTypeDecl fAnyType;
    protected final short fSchemaVersion;

    public static XSParticleDecl getEmptySequence() {
        if (fEmptyParticle == null) {
            XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
            xSModelGroupImpl.fCompositor = (short)102;
            xSModelGroupImpl.fParticleCount = 0;
            xSModelGroupImpl.fParticles = null;
            xSModelGroupImpl.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            XSParticleDecl xSParticleDecl = new XSParticleDecl();
            xSParticleDecl.fType = (short)3;
            xSParticleDecl.fValue = xSModelGroupImpl;
            xSParticleDecl.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            fEmptyParticle = xSParticleDecl;
        }
        return fEmptyParticle;
    }

    protected XSConstraints(XSComplexTypeDecl xSComplexTypeDecl, short s) {
        this.fAnyType = xSComplexTypeDecl;
        this.fSchemaVersion = s;
    }

    public final short getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public boolean isTypeTablesEquivalent(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        return true;
    }

    public boolean checkTypeDerivationOk(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s) {
        if (xSTypeDefinition == this.fAnyType) {
            return xSTypeDefinition == xSTypeDefinition2;
        }
        if (xSTypeDefinition == SchemaGrammar.fAnySimpleType) {
            return xSTypeDefinition2 == this.fAnyType || xSTypeDefinition2 == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDefinition.getTypeCategory() == 16) {
            if (xSTypeDefinition2.getTypeCategory() == 15) {
                if (xSTypeDefinition2 == this.fAnyType) {
                    xSTypeDefinition2 = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)xSTypeDefinition, (XSSimpleType)xSTypeDefinition2, s);
        }
        return this.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition, xSTypeDefinition2, s);
    }

    public boolean checkSimpleDerivationOk(XSSimpleType xSSimpleType, XSTypeDefinition xSTypeDefinition, short s) {
        if (xSSimpleType == SchemaGrammar.fAnySimpleType) {
            return xSTypeDefinition == this.fAnyType || xSTypeDefinition == SchemaGrammar.fAnySimpleType;
        }
        if (xSTypeDefinition.getTypeCategory() == 15) {
            if (xSTypeDefinition == this.fAnyType) {
                xSTypeDefinition = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return this.checkSimpleDerivation(xSSimpleType, (XSSimpleType)xSTypeDefinition, s);
    }

    public boolean checkComplexDerivationOk(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDefinition xSTypeDefinition, short s) {
        if (xSComplexTypeDecl == this.fAnyType) {
            return xSComplexTypeDecl == xSTypeDefinition;
        }
        return this.checkComplexDerivation(xSComplexTypeDecl, xSTypeDefinition, s);
    }

    private boolean checkSimpleDerivation(XSSimpleType xSSimpleType, XSSimpleType xSSimpleType2, short s) {
        if (xSSimpleType == xSSimpleType2) {
            return true;
        }
        if ((s & 2) != 0 || (xSSimpleType.getBaseType().getFinal() & 2) != 0) {
            return false;
        }
        XSSimpleType xSSimpleType3 = (XSSimpleType)xSSimpleType.getBaseType();
        if (xSSimpleType3 == xSSimpleType2) {
            return true;
        }
        if (xSSimpleType3 != SchemaGrammar.fAnySimpleType && this.checkSimpleDerivation(xSSimpleType3, xSSimpleType2, s)) {
            return true;
        }
        if ((xSSimpleType.getVariety() == 2 || xSSimpleType.getVariety() == 3) && xSSimpleType2 == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (xSSimpleType2.getVariety() == 3 && this.checkEmptyFacets(xSSimpleType2)) {
            XSObjectList xSObjectList = xSSimpleType2.getMemberTypes();
            int n = xSObjectList.getLength();
            for (int i = 0; i < n; ++i) {
                xSSimpleType2 = (XSSimpleType)xSObjectList.item(i);
                if (!this.checkSimpleDerivation(xSSimpleType, xSSimpleType2, s)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkComplexDerivation(XSComplexTypeDecl xSComplexTypeDecl, XSTypeDefinition xSTypeDefinition, short s) {
        if (xSComplexTypeDecl == xSTypeDefinition) {
            return true;
        }
        if ((xSComplexTypeDecl.fDerivedBy & s) != 0) {
            return false;
        }
        XSTypeDefinition xSTypeDefinition2 = xSComplexTypeDecl.fBaseType;
        if (xSTypeDefinition2 == xSTypeDefinition) {
            return true;
        }
        if (xSTypeDefinition2 == this.fAnyType || xSTypeDefinition2 == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (xSTypeDefinition2.getTypeCategory() == 15) {
            return this.checkComplexDerivation((XSComplexTypeDecl)xSTypeDefinition2, xSTypeDefinition, s);
        }
        if (xSTypeDefinition2.getTypeCategory() == 16) {
            if (xSTypeDefinition.getTypeCategory() == 15) {
                if (xSTypeDefinition == this.fAnyType) {
                    xSTypeDefinition = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return this.checkSimpleDerivation((XSSimpleType)xSTypeDefinition2, (XSSimpleType)xSTypeDefinition, s);
        }
        return false;
    }

    public Object ElementDefaultValidImmediate(XSTypeDefinition xSTypeDefinition, String string, ValidationContext validationContext, ValidatedInfo validatedInfo) {
        Object object;
        XSSimpleType xSSimpleType = null;
        if (xSTypeDefinition.getTypeCategory() == 16) {
            xSSimpleType = (XSSimpleType)xSTypeDefinition;
        } else {
            object = (XSComplexTypeDecl)xSTypeDefinition;
            if (((XSComplexTypeDecl)object).fContentType == 1) {
                xSSimpleType = ((XSComplexTypeDecl)object).fXSSimpleType;
            } else if (((XSComplexTypeDecl)object).fContentType == 3) {
                if (!((XSParticleDecl)((XSComplexTypeDecl)object).getParticle()).emptiable()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        object = null;
        if (xSSimpleType == null) {
            xSSimpleType = STRING_TYPE;
        }
        try {
            object = xSSimpleType.validate(string, validationContext, validatedInfo);
            if (validatedInfo != null) {
                object = xSSimpleType.validate(validatedInfo.stringValue(), validationContext, validatedInfo);
            }
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            return null;
        }
        return object;
    }

    void reportSchemaError(XMLErrorReporter xMLErrorReporter, SimpleLocator simpleLocator, String string, Object[] objectArray) {
        if (simpleLocator != null) {
            xMLErrorReporter.reportError(simpleLocator, "http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        } else {
            xMLErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", string, objectArray, (short)1);
        }
    }

    public void fullSchemaChecking(XSGrammarBucket xSGrammarBucket, SubstitutionGroupHandler substitutionGroupHandler, CMBuilder cMBuilder, XMLErrorReporter xMLErrorReporter) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object[] objectArray;
        SchemaGrammar[] schemaGrammarArray = xSGrammarBucket.getGrammars();
        for (int i = schemaGrammarArray.length - 1; i >= 0; --i) {
            substitutionGroupHandler.addSubstitutionGroup(schemaGrammarArray[i].getSubstitutionGroups());
        }
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl.fType = (short)3;
        xSParticleDecl2.fType = (short)3;
        for (int i = schemaGrammarArray.length - 1; i >= 0; --i) {
            objectArray = schemaGrammarArray[i].getRedefinedGroupDecls();
            SimpleLocator[] simpleLocatorArray = schemaGrammarArray[i].getRGLocators();
            n = 0;
            while (n < objectArray.length) {
                XSGroupDecl xSGroupDecl = objectArray[n++];
                object3 = xSGroupDecl.fModelGroup;
                object2 = objectArray[n++];
                object = ((XSGroupDecl)object2).fModelGroup;
                xSParticleDecl.fValue = object3;
                xSParticleDecl2.fValue = object;
                if (object == null) {
                    if (object3 == null) continue;
                    this.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, "rcase-Recurse.2"});
                    continue;
                }
                if (object3 == null) {
                    if (xSParticleDecl2.emptiable()) continue;
                    this.reportSchemaError(xMLErrorReporter, simpleLocatorArray[n / 2 - 1], "src-redefine.6.2.2", new Object[]{xSGroupDecl.fName, "rcase-Recurse.2"});
                    continue;
                }
                this.groupSubsumption(xSParticleDecl, xSParticleDecl2, xSGrammarBucket, substitutionGroupHandler, cMBuilder, xMLErrorReporter, xSGroupDecl.fName, simpleLocatorArray[n / 2 - 1]);
            }
        }
        object3 = new SymbolHash();
        object2 = new Stack();
        object = this.fSchemaVersion == 4 ? new ArrayList() : null;
        for (int i = schemaGrammarArray.length - 1; i >= 0; --i) {
            int n2 = 0;
            n = schemaGrammarArray[i].fFullChecked ? 1 : 0;
            XSComplexTypeDecl[] xSComplexTypeDeclArray = schemaGrammarArray[i].getUncheckedComplexTypeDecls();
            objectArray = schemaGrammarArray[i].getUncheckedCTLocators();
            for (int j = 0; j < xSComplexTypeDeclArray.length; ++j) {
                Object object4;
                if (n == 0 && xSComplexTypeDeclArray[j].fParticle != null) {
                    ((SymbolHash)object3).clear();
                    try {
                        this.checkElementDeclsConsistent(xSComplexTypeDeclArray[j], xSComplexTypeDeclArray[j].fParticle, (SymbolHash)object3, substitutionGroupHandler, xSGrammarBucket, (ArrayList)object, (Stack)object2);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[j], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (xSComplexTypeDeclArray[j].fBaseType != null && xSComplexTypeDeclArray[j].fBaseType != this.fAnyType && xSComplexTypeDeclArray[j].fDerivedBy == 2 && xSComplexTypeDeclArray[j].fBaseType instanceof XSComplexTypeDecl) {
                    object4 = xSComplexTypeDeclArray[j].fParticle;
                    XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSComplexTypeDeclArray[j].fBaseType;
                    XSParticleDecl xSParticleDecl3 = xSComplexTypeDecl.fParticle;
                    if (object4 == null) {
                        if (xSParticleDecl3 != null && !xSParticleDecl3.emptiable()) {
                            this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[j], "derivation-ok-restriction.5.3.2", new Object[]{xSComplexTypeDeclArray[j].fName, xSComplexTypeDeclArray[j].fBaseType.getName()});
                        }
                    } else if (xSParticleDecl3 != null) {
                        this.typeSubsumption(xSComplexTypeDeclArray[j], xSComplexTypeDecl, xSGrammarBucket, substitutionGroupHandler, cMBuilder, xMLErrorReporter, (SimpleLocator)objectArray[j]);
                    } else {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[j], "derivation-ok-restriction.5.4.2", new Object[]{xSComplexTypeDeclArray[j].fName});
                    }
                }
                object4 = xSComplexTypeDeclArray[j].getContentModel(cMBuilder, true);
                boolean bl = false;
                if (object4 != null) {
                    try {
                        bl = object4.checkUniqueParticleAttribution(substitutionGroupHandler, this);
                    }
                    catch (XMLSchemaException xMLSchemaException) {
                        this.reportSchemaError(xMLErrorReporter, (SimpleLocator)objectArray[j], xMLSchemaException.getKey(), xMLSchemaException.getArgs());
                    }
                }
                if (n != 0 || !bl) continue;
                xSComplexTypeDeclArray[n2++] = xSComplexTypeDeclArray[j];
            }
            if (n != 0) continue;
            schemaGrammarArray[i].setUncheckedTypeNum(n2);
            schemaGrammarArray[i].fFullChecked = true;
        }
    }

    public void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        short s = xSParticleDecl.fType;
        if (s == 2) {
            return;
        }
        if (s == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            this.findElemInTable(xSComplexTypeDecl, xSElementDecl, symbolHash);
            if (xSElementDecl.fScope == 1) {
                XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
                for (int i = 0; i < xSElementDeclArray.length; ++i) {
                    this.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[i], symbolHash);
                }
            }
            return;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
            this.checkElementDeclsConsistent(xSComplexTypeDecl, xSModelGroupImpl.fParticles[i], symbolHash, substitutionGroupHandler);
        }
    }

    protected void checkElementDeclsConsistent(XSComplexTypeDecl xSComplexTypeDecl, XSParticleDecl xSParticleDecl, SymbolHash symbolHash, SubstitutionGroupHandler substitutionGroupHandler, XSGrammarBucket xSGrammarBucket, ArrayList arrayList, Stack stack) throws XMLSchemaException {
        if (stack.size() > 0) {
            stack.clear();
        }
        while (true) {
            short s;
            if ((s = xSParticleDecl.fType) != 2) {
                XSTerm xSTerm;
                if (s == 1) {
                    xSTerm = (XSElementDecl)xSParticleDecl.fValue;
                    this.findElemInTable(xSComplexTypeDecl, (XSElementDecl)xSTerm, symbolHash);
                    if (xSTerm.fScope == 1) {
                        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup((XSElementDecl)xSTerm, this.fSchemaVersion);
                        for (int i = 0; i < xSElementDeclArray.length; ++i) {
                            this.findElemInTable(xSComplexTypeDecl, xSElementDeclArray[i], symbolHash);
                        }
                    }
                } else {
                    xSTerm = (XSModelGroupImpl)xSParticleDecl.fValue;
                    for (int i = ((XSModelGroupImpl)xSTerm).fParticleCount - 1; i >= 0; --i) {
                        stack.push(((XSModelGroupImpl)xSTerm).fParticles[i]);
                    }
                }
            }
            if (stack.isEmpty()) break;
            xSParticleDecl = (XSParticleDecl)stack.pop();
        }
    }

    public void findElemInTable(XSComplexTypeDecl xSComplexTypeDecl, XSElementDecl xSElementDecl, SymbolHash symbolHash) throws XMLSchemaException {
        XSElementDecl xSElementDecl2 = this.findExistingElement(xSElementDecl, symbolHash);
        if (xSElementDecl2 == null || xSElementDecl2 == xSElementDecl) {
            return;
        }
        if (xSElementDecl.fType != xSElementDecl2.fType) {
            throw new XMLSchemaException("cos-element-consistent", new Object[]{xSComplexTypeDecl.fName, xSElementDecl.fName});
        }
    }

    protected XSElementDecl findExistingElement(XSElementDecl xSElementDecl, SymbolHash symbolHash) {
        String string = xSElementDecl.fName + "," + xSElementDecl.fTargetNamespace;
        XSElementDecl xSElementDecl2 = (XSElementDecl)symbolHash.get(string);
        if (xSElementDecl2 == null) {
            symbolHash.put(string, xSElementDecl);
        }
        return xSElementDecl2;
    }

    protected boolean overlapUPA(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, SubstitutionGroupHandler substitutionGroupHandler) {
        int n;
        if (xSElementDecl.fName == xSElementDecl2.fName && xSElementDecl.fTargetNamespace == xSElementDecl2.fTargetNamespace) {
            return true;
        }
        XSElementDecl[] xSElementDeclArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl, this.fSchemaVersion);
        for (int i = xSElementDeclArray.length - 1; i >= 0; --i) {
            if (xSElementDeclArray[i].fName != xSElementDecl2.fName || xSElementDeclArray[i].fTargetNamespace != xSElementDecl2.fTargetNamespace) continue;
            return true;
        }
        XSElementDecl[] xSElementDeclArray2 = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl2, this.fSchemaVersion);
        for (n = xSElementDeclArray2.length - 1; n >= 0; --n) {
            if (xSElementDeclArray2[n].fName != xSElementDecl.fName || xSElementDeclArray2[n].fTargetNamespace != xSElementDecl.fTargetNamespace) continue;
            return true;
        }
        for (n = xSElementDeclArray.length - 1; n >= 0; --n) {
            for (int i = xSElementDeclArray2.length - 1; i >= 0; --i) {
                if (xSElementDeclArray[n].fName != xSElementDeclArray2[i].fName || xSElementDeclArray[n].fTargetNamespace != xSElementDeclArray2[i].fTargetNamespace) continue;
                return true;
            }
        }
        return false;
    }

    public boolean overlapUPA(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        XSWildcardDecl xSWildcardDecl3 = this.performIntersectionWith(xSWildcardDecl, xSWildcardDecl2, xSWildcardDecl.fProcessContents);
        return xSWildcardDecl3 == null || xSWildcardDecl3.fType != 3 || xSWildcardDecl3.fNamespaceList.length != 0;
    }

    public boolean overlapUPA(Object object, Object object2, SubstitutionGroupHandler substitutionGroupHandler) {
        if (object instanceof XSElementDecl) {
            if (object2 instanceof XSElementDecl) {
                return this.overlapUPA((XSElementDecl)object, (XSElementDecl)object2, substitutionGroupHandler);
            }
            return this.overlapUPA((XSElementDecl)object, (XSWildcardDecl)object2, substitutionGroupHandler);
        }
        if (object2 instanceof XSElementDecl) {
            return this.overlapUPA((XSElementDecl)object2, (XSWildcardDecl)object, substitutionGroupHandler);
        }
        return this.overlapUPA((XSWildcardDecl)object, (XSWildcardDecl)object2);
    }

    boolean areSame(XSWildcardDecl xSWildcardDecl, XSWildcardDecl xSWildcardDecl2) {
        if (xSWildcardDecl.fType == xSWildcardDecl2.fType) {
            if (xSWildcardDecl.fType == 1) {
                return true;
            }
            if (xSWildcardDecl.fType == 2) {
                return xSWildcardDecl.fNamespaceList[0] == xSWildcardDecl2.fNamespaceList[0];
            }
            if (xSWildcardDecl.fNamespaceList.length == xSWildcardDecl2.fNamespaceList.length) {
                for (int i = 0; i < xSWildcardDecl.fNamespaceList.length; ++i) {
                    if (this.elementInSet(xSWildcardDecl.fNamespaceList[i], xSWildcardDecl2.fNamespaceList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    String[] intersect2sets(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[Math.min(stringArray.length, stringArray2.length)];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.elementInSet(stringArray[i], stringArray2)) continue;
            stringArray3[n++] = stringArray[i];
        }
        String[] stringArray4 = new String[n];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n);
        return stringArray4;
    }

    String[] union2sets(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.elementInSet(stringArray[i], stringArray2)) continue;
            stringArray3[n++] = stringArray[i];
        }
        String[] stringArray4 = new String[n + stringArray2.length];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n);
        System.arraycopy(stringArray2, 0, stringArray4, n, stringArray2.length);
        return stringArray4;
    }

    boolean subset2sets(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.elementInSet(stringArray[i], stringArray2)) continue;
            return false;
        }
        return true;
    }

    boolean elementInSet(String string, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            if (string != stringArray[i]) continue;
            bl = true;
        }
        return bl;
    }

    boolean disjoint2sets(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.elementInSet(stringArray[i], stringArray2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isSubsetOf(XSWildcardDecl var1, XSWildcardDecl var2);

    public abstract XSWildcardDecl performUnionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    public abstract XSWildcardDecl performIntersectionWith(XSWildcardDecl var1, XSWildcardDecl var2, short var3);

    protected abstract boolean checkEmptyFacets(XSSimpleType var1);

    public abstract boolean overlapUPA(XSElementDecl var1, XSWildcardDecl var2, SubstitutionGroupHandler var3);

    protected abstract void groupSubsumption(XSParticleDecl var1, XSParticleDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, String var7, SimpleLocator var8);

    protected abstract void typeSubsumption(XSComplexTypeDecl var1, XSComplexTypeDecl var2, XSGrammarBucket var3, SubstitutionGroupHandler var4, CMBuilder var5, XMLErrorReporter var6, SimpleLocator var7);
}

