/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xs;

import repackage.org.apache.xerces.impl.dv.ValidatedInfo;
import repackage.org.apache.xerces.impl.xs.PSVIErrorList;
import repackage.org.apache.xerces.impl.xs.SchemaGrammar;
import repackage.org.apache.xerces.impl.xs.XSModelImpl;
import repackage.org.apache.xerces.impl.xs.util.ObjectListImpl;
import repackage.org.apache.xerces.impl.xs.util.StringListImpl;
import repackage.org.apache.xerces.xs.ElementPSVI;
import repackage.org.apache.xerces.xs.ItemPSVI;
import repackage.org.apache.xerces.xs.ShortList;
import repackage.org.apache.xerces.xs.StringList;
import repackage.org.apache.xerces.xs.XSElementDeclaration;
import repackage.org.apache.xerces.xs.XSModel;
import repackage.org.apache.xerces.xs.XSNotationDeclaration;
import repackage.org.apache.xerces.xs.XSSimpleTypeDefinition;
import repackage.org.apache.xerces.xs.XSTypeAlternative;
import repackage.org.apache.xerces.xs.XSTypeDefinition;
import repackage.org.apache.xerces.xs.XSValue;
import repackage.org.apache.xerces.xs.datatypes.ObjectList;

public class ElementPSVImpl
implements ElementPSVI {
    protected XSElementDeclaration fDeclaration = null;
    protected XSTypeDefinition fTypeDecl = null;
    protected boolean fNil = false;
    protected boolean fSpecified = false;
    protected ValidatedInfo fValue = new ValidatedInfo();
    protected XSNotationDeclaration fNotation = null;
    protected short fValidationAttempted = 0;
    protected short fValidity = 0;
    protected String[] fErrors = null;
    protected String fValidationContext = null;
    protected SchemaGrammar[] fGrammars = null;
    protected XSModel fSchemaInformation = null;
    protected boolean fIsConstant;
    protected ObjectList fInheritedAttributes = null;
    protected ObjectList fFailedAssertions = null;
    protected XSTypeAlternative fTypeAlternative = null;

    public ElementPSVImpl() {
    }

    public ElementPSVImpl(boolean bl, ElementPSVI elementPSVI) {
        this.fDeclaration = elementPSVI.getElementDeclaration();
        this.fTypeDecl = elementPSVI.getTypeDefinition();
        this.fNil = elementPSVI.getNil();
        this.fSpecified = elementPSVI.getIsSchemaSpecified();
        this.fValue.copyFrom(elementPSVI.getSchemaValue());
        this.fNotation = elementPSVI.getNotation();
        this.fValidationAttempted = elementPSVI.getValidationAttempted();
        this.fValidity = elementPSVI.getValidity();
        this.fValidationContext = elementPSVI.getValidationContext();
        this.fTypeAlternative = elementPSVI.getTypeAlternative();
        this.fInheritedAttributes = elementPSVI.getInheritedAttributes();
        this.fFailedAssertions = elementPSVI.getFailedAssertions();
        if (elementPSVI instanceof ElementPSVImpl) {
            ElementPSVImpl elementPSVImpl = (ElementPSVImpl)elementPSVI;
            this.fErrors = elementPSVImpl.fErrors != null ? (String[])elementPSVImpl.fErrors.clone() : null;
            elementPSVImpl.copySchemaInformationTo(this);
        } else {
            StringList stringList = elementPSVI.getErrorCodes();
            int n = stringList.getLength();
            if (n > 0) {
                StringList stringList2 = elementPSVI.getErrorMessages();
                String[] stringArray = new String[n << 1];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    stringArray[n2++] = stringList.item(i);
                    stringArray[n2++] = stringList2.item(i);
                }
                this.fErrors = stringArray;
            }
            this.fSchemaInformation = elementPSVI.getSchemaInformation();
        }
        this.fIsConstant = bl;
    }

    public ItemPSVI constant() {
        if (this.isConstant()) {
            return this;
        }
        return new ElementPSVImpl(true, this);
    }

    public boolean isConstant() {
        return this.fIsConstant;
    }

    public String getSchemaDefault() {
        return this.fDeclaration == null ? null : this.fDeclaration.getConstraintValue();
    }

    public String getSchemaNormalizedValue() {
        return this.fValue.getNormalizedValue();
    }

    public boolean getIsSchemaSpecified() {
        return this.fSpecified;
    }

    public short getValidationAttempted() {
        return this.fValidationAttempted;
    }

    public short getValidity() {
        return this.fValidity;
    }

    public StringList getErrorCodes() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, true);
    }

    public StringList getErrorMessages() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, false);
    }

    public String getValidationContext() {
        return this.fValidationContext;
    }

    public boolean getNil() {
        return this.fNil;
    }

    public XSNotationDeclaration getNotation() {
        return this.fNotation;
    }

    public XSTypeDefinition getTypeDefinition() {
        return this.fTypeDecl;
    }

    public XSSimpleTypeDefinition getMemberTypeDefinition() {
        return this.fValue.getMemberTypeDefinition();
    }

    public XSElementDeclaration getElementDeclaration() {
        return this.fDeclaration;
    }

    public synchronized XSModel getSchemaInformation() {
        if (this.fSchemaInformation == null && this.fGrammars != null) {
            this.fSchemaInformation = new XSModelImpl(this.fGrammars);
        }
        return this.fSchemaInformation;
    }

    public Object getActualNormalizedValue() {
        return this.fValue.getActualValue();
    }

    public short getActualNormalizedValueType() {
        return this.fValue.getActualValueType();
    }

    public ShortList getItemValueTypes() {
        return this.fValue.getListValueTypes();
    }

    public XSValue getSchemaValue() {
        return this.fValue;
    }

    public ObjectList getInheritedAttributes() {
        if (this.fInheritedAttributes != null) {
            return this.fInheritedAttributes;
        }
        return ObjectListImpl.EMPTY_LIST;
    }

    public ObjectList getFailedAssertions() {
        if (this.fFailedAssertions != null) {
            return this.fFailedAssertions;
        }
        return ObjectListImpl.EMPTY_LIST;
    }

    public XSTypeAlternative getTypeAlternative() {
        return this.fTypeAlternative;
    }

    public void reset() {
        this.fDeclaration = null;
        this.fTypeDecl = null;
        this.fNil = false;
        this.fSpecified = false;
        this.fNotation = null;
        this.fValidationAttempted = 0;
        this.fValidity = 0;
        this.fErrors = null;
        this.fValidationContext = null;
        this.fValue.reset();
        this.fTypeAlternative = null;
        this.fInheritedAttributes = null;
        this.fFailedAssertions = null;
    }

    public void copySchemaInformationTo(ElementPSVImpl elementPSVImpl) {
        elementPSVImpl.fGrammars = this.fGrammars;
        elementPSVImpl.fSchemaInformation = this.fSchemaInformation;
    }
}

