/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xpath;

import repackage.org.apache.xerces.impl.dv.XSSimpleType;
import repackage.org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import repackage.org.apache.xerces.xni.NamespaceContext;
import repackage.org.apache.xerces.xni.QName;
import repackage.org.apache.xerces.xni.XMLAttributes;

class LiteralNode
extends XPathSyntaxTreeNode {
    private String value;
    private boolean isNumeric;

    public LiteralNode(String string, boolean bl) {
        this.value = string;
        this.isNumeric = bl;
    }

    public boolean evaluate(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) throws Exception {
        Object object = this.getValue(xMLAttributes, namespaceContext);
        if (this.isNumeric) {
            return object != null && 0.0 != (Double)object;
        }
        return object != null;
    }

    public Object getValue(XMLAttributes xMLAttributes, NamespaceContext namespaceContext) throws Exception {
        XSSimpleType xSSimpleType = this.isNumeric ? dvFactory.getBuiltInType("double") : dvFactory.getBuiltInType("string");
        return xSSimpleType.validate(this.value, null, null);
    }

    public String getStringValue() {
        return this.value;
    }

    public int getType() {
        return this.isNumeric ? 0 : 1;
    }
}

