/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.xpath;

import repackage.org.apache.xerces.impl.dv.XSSimpleType;
import repackage.org.apache.xerces.impl.xpath.XPathException;
import repackage.org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import repackage.org.apache.xerces.xni.NamespaceContext;
import repackage.org.apache.xerces.xni.QName;
import repackage.org.apache.xerces.xni.XMLAttributes;

class CastNode
extends XPathSyntaxTreeNode {
    private XSSimpleType castedType;
    private XPathSyntaxTreeNode child;

    public CastNode(XPathSyntaxTreeNode xPathSyntaxTreeNode, QName qName) throws XPathException {
        this.child = xPathSyntaxTreeNode;
        if (!"http://www.w3.org/2001/XMLSchema".equals(qName.uri)) {
            throw new XPathException("Casted type is not a built-in type");
        }
        this.castedType = dvFactory.getBuiltInType(qName.localpart);
        if (this.castedType == null) {
            throw new XPathException("Casted type is not a built-in type");
        }
    }

    public boolean evaluate(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) throws Exception {
        Object object = this.getValue(xMLAttributes, namespaceContext);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        if (object instanceof Double) {
            return (Double)object != 0.0;
        }
        return true;
    }

    public Object getValue(XMLAttributes xMLAttributes, NamespaceContext namespaceContext) throws Exception {
        Object object;
        XSSimpleType xSSimpleType = this.getSimpleType();
        if (this.child.getType() == 2) {
            String string = this.child.getValue(xMLAttributes, namespaceContext).toString();
            object = xSSimpleType.validate(string, null, null);
        } else {
            object = xSSimpleType.validate(this.child.getStringValue(), null, null);
        }
        if (xSSimpleType.getNumeric()) {
            object = dvFactory.getBuiltInType("double").validate(object, null, null);
        }
        return object;
    }

    public XSSimpleType getSimpleType() {
        return this.castedType;
    }

    public int getType() {
        if (this.castedType.getNumeric()) {
            return 0;
        }
        if (this.castedType.getName().equals("string")) {
            return 1;
        }
        return 3;
    }
}

