/*
 * Decompiled with CFR 0.152.
 */
package repackage.org.apache.xerces.impl.scd;

import java.util.ArrayList;
import java.util.List;
import repackage.org.apache.xerces.impl.scd.SCDException;
import repackage.org.apache.xerces.impl.scd.SCDParser;
import repackage.org.apache.xerces.impl.scd.Step;
import repackage.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import repackage.org.apache.xerces.xni.NamespaceContext;
import repackage.org.apache.xerces.xni.QName;
import repackage.org.apache.xerces.xs.XSAttributeDeclaration;
import repackage.org.apache.xerces.xs.XSAttributeGroupDefinition;
import repackage.org.apache.xerces.xs.XSAttributeUse;
import repackage.org.apache.xerces.xs.XSComplexTypeDefinition;
import repackage.org.apache.xerces.xs.XSElementDeclaration;
import repackage.org.apache.xerces.xs.XSFacet;
import repackage.org.apache.xerces.xs.XSIDCDefinition;
import repackage.org.apache.xerces.xs.XSModel;
import repackage.org.apache.xerces.xs.XSModelGroup;
import repackage.org.apache.xerces.xs.XSModelGroupDefinition;
import repackage.org.apache.xerces.xs.XSMultiValueFacet;
import repackage.org.apache.xerces.xs.XSNamedMap;
import repackage.org.apache.xerces.xs.XSNotationDeclaration;
import repackage.org.apache.xerces.xs.XSObject;
import repackage.org.apache.xerces.xs.XSObjectList;
import repackage.org.apache.xerces.xs.XSParticle;
import repackage.org.apache.xerces.xs.XSSimpleTypeDefinition;
import repackage.org.apache.xerces.xs.XSTerm;
import repackage.org.apache.xerces.xs.XSTypeDefinition;
import repackage.org.apache.xerces.xs.XSWildcard;

public class SCDResolver {
    private XSModel xsModel;
    private List result;
    private List currentComponents;
    private SCDParser parser;
    private static final short NO_FILTER = -1;
    private static final boolean IS_SPEC_COMPLIANT = false;
    private static final short LIST_SIZE = 30;

    public SCDResolver(XSModel xSModel) {
        this.xsModel = xSModel;
        this.result = new ArrayList(30);
        this.currentComponents = new ArrayList(30);
        this.parser = new SCDParser();
    }

    public XSObjectList resolve(String string) throws SCDException {
        List list = this.parser.parseRelativeSCD(string, false);
        if (list.size() == 1 && ((Step)list.get(0)).getAxisType() == 100 && ((Step)list.get(0)).getNametest() == null && ((Step)list.get(0)).getPredicate() == 0) {
            throw new SCDException("Error in SCD: Schema step is not supported");
        }
        this.result.clear();
        this.applyFirstStep((Step)list.get(0));
        return this.evaluate(list, 1);
    }

    public XSObjectList resolve(String string, NamespaceContext namespaceContext) throws SCDException {
        List list = this.parser.parseSCP(string, namespaceContext, false);
        if (list.size() == 1 && ((Step)list.get(0)).getAxisType() == 100 && ((Step)list.get(0)).getNametest() == null && ((Step)list.get(0)).getPredicate() == 0) {
            throw new SCDException("Error in SCD: Schema step is not supported");
        }
        this.result.clear();
        this.applyFirstStep((Step)list.get(0));
        return this.evaluate(list, 1);
    }

    public XSObjectList resolve(String string, NamespaceContext namespaceContext, XSObject xSObject) throws SCDException {
        List list = this.parser.parseSCP(string, namespaceContext, true);
        this.result.clear();
        this.result.add(xSObject);
        return this.evaluate(list, 0);
    }

    public XSObjectList resolve(String string, XSObject xSObject) throws SCDException {
        List list = this.parser.parseRelativeSCD(string, true);
        this.result.clear();
        this.result.add(xSObject);
        return this.evaluate(list, 0);
    }

    private XSObjectList evaluate(List list, int n) throws SCDException {
        int n2 = list.size();
        for (int i = n; i < n2; ++i) {
            int n3;
            this.currentComponents.clear();
            Step step = (Step)list.get(i);
            short s = step.getAxisType();
            int n4 = this.result.size();
            for (n3 = 0; n3 < n4; ++n3) {
                this.currentComponents.add(this.result.get(n3));
            }
            if (s != 27) {
                n4 = this.currentComponents.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.addElidedComponents((XSObject)this.currentComponents.get(n3));
                }
            }
            this.result.clear();
            this.applyStep(step);
            if (s != 27) continue;
            step = (Step)list.get(++i);
            List list2 = this.currentComponents;
            this.currentComponents = this.result;
            this.result = list2;
            this.result.clear();
            this.applyStep(step);
        }
        XSObjectListImpl xSObjectListImpl = new XSObjectListImpl();
        int n5 = this.result.size();
        for (n2 = 0; n2 < n5; ++n2) {
            xSObjectListImpl.addXSObject((XSObject)this.result.get(n2));
        }
        return xSObjectListImpl;
    }

    private void addElidedComponents(XSObject xSObject) {
        for (int i = this.currentComponents.size() - 1; i < this.currentComponents.size(); ++i) {
            this.term((XSObject)this.currentComponents.get(i), (short)7, SCDParser.WILDCARD, this.currentComponents);
        }
        switch (xSObject.getType()) {
            case 2: {
                XSTypeDefinition xSTypeDefinition = ((XSElementDeclaration)xSObject).getTypeDefinition();
                if (xSTypeDefinition == null || this.currentComponents.contains(xSTypeDefinition)) break;
                this.currentComponents.add(xSTypeDefinition);
                break;
            }
            case 1: {
                XSSimpleTypeDefinition xSSimpleTypeDefinition = ((XSAttributeDeclaration)xSObject).getTypeDefinition();
                if (xSSimpleTypeDefinition == null || this.currentComponents.contains(xSSimpleTypeDefinition)) break;
                this.currentComponents.add(xSSimpleTypeDefinition);
            }
        }
    }

    private void applyFirstStep(Step step) throws SCDException {
        int n;
        XSNamedMap xSNamedMap = null;
        switch (step.getAxisType()) {
            case 21: {
                XSObjectList xSObjectList = this.xsModel.getAnnotations();
                int n2 = xSObjectList.size();
                for (n = 0; n < n2; ++n) {
                    this.addComponent(xSObjectList.item(n), step.getNametest(), this.result);
                }
                break;
            }
            case 1: {
                xSNamedMap = this.xsModel.getComponents((short)2);
                break;
            }
            case 2: {
                xSNamedMap = this.xsModel.getComponents((short)3);
                break;
            }
            case 0: {
                xSNamedMap = this.xsModel.getComponents((short)1);
                break;
            }
            case 3: {
                xSNamedMap = this.xsModel.getComponents((short)5);
                break;
            }
            case 4: {
                xSNamedMap = this.xsModel.getComponents((short)6);
                break;
            }
            case 8: {
                xSNamedMap = this.xsModel.getComponents((short)11);
                break;
            }
            case 22: 
            case 27: {
                int n2;
                this.currentComponents.clear();
                this.addTopLevelComponents(step.getNametest());
                n = this.currentComponents.size();
                for (n2 = 0; n2 < this.currentComponents.size(); ++n2) {
                    this.componentChildren((XSObject)this.currentComponents.get(n2), (short)-1, SCDParser.WILDCARD, this.currentComponents);
                }
                for (int i = n2 = step.getAxisType() == 27 ? 0 : n; i < this.currentComponents.size(); ++i) {
                    this.addComponent((XSObject)this.currentComponents.get(i), step.getNametest(), this.result);
                }
                break;
            }
            default: {
                throw new SCDException("Error in SCD: Unsupported top level component type " + step.getAxisName());
            }
        }
        if (xSNamedMap != null && !xSNamedMap.isEmpty()) {
            n = xSNamedMap.size();
            for (int i = 0; i < n; ++i) {
                this.addComponent(xSNamedMap.item(i), step.getNametest(), this.result);
            }
        }
        this.applyPredicate(step.getPredicate());
    }

    private void applyStep(Step step) throws SCDException {
        switch (step.getAxisType()) {
            case 1: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)2, step.getNametest(), this.result);
                }
                break;
            }
            case 0: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)1, step.getNametest(), this.result);
                }
                break;
            }
            case 2: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentChildren((XSObject)this.currentComponents.get(i), (short)3, step.getNametest(), this.result);
                }
                break;
            }
            case 23: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.result.add(this.currentComponents.get(i));
                }
                return;
            }
            case 22: 
            case 27: {
                int n;
                int n2 = this.currentComponents.size();
                for (n = 0; n < this.currentComponents.size(); ++n) {
                    this.componentChildren((XSObject)this.currentComponents.get(n), (short)-1, SCDParser.WILDCARD, this.currentComponents);
                }
                for (int i = n = step.getAxisType() == 27 ? 0 : n2; i < this.currentComponents.size(); ++i) {
                    this.addComponent((XSObject)this.currentComponents.get(i), step.getNametest(), this.result);
                }
                break;
            }
            case 3: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)5, step.getNametest(), this.result);
                }
                break;
            }
            case 4: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)6, step.getNametest(), this.result);
                }
                break;
            }
            case 5: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)10, step.getNametest(), this.result);
                }
                break;
            }
            case 6: {
                throw new SCDException("Error in SCD: Assertion axis is not supported");
            }
            case 7: {
                throw new SCDException("Error in SCD: Alternative axis is not supported");
            }
            case 8: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)11, step.getNametest(), this.result);
                }
                break;
            }
            case 9: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)7, step.getNametest(), this.result);
                }
                break;
            }
            case 10: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject = (XSObject)this.currentComponents.get(i);
                    short s = xSObject.getType();
                    if (s == 3) {
                        s = ((XSTypeDefinition)xSObject).getTypeCategory();
                        if (s != 15) continue;
                        this.addComponent(((XSComplexTypeDefinition)xSObject).getAttributeWildcard(), step.getNametest(), this.result);
                        continue;
                    }
                    if (s != 5) continue;
                    this.addComponent(((XSAttributeGroupDefinition)xSObject).getAttributeWildcard(), step.getNametest(), this.result);
                }
                break;
            }
            case 11: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)9, step.getNametest(), this.result);
                }
                break;
            }
            case 12: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)13, step.getNametest(), this.result);
                }
                break;
            }
            case 13: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentScope((XSObject)this.currentComponents.get(i), this.result);
                }
                break;
            }
            case 14: {
                throw new SCDException("Error in SCD: Context axis is not supported");
            }
            case 15: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject = (XSObject)this.currentComponents.get(i);
                    if (xSObject.getType() != 2) continue;
                    this.addComponent(((XSElementDeclaration)xSObject).getSubstitutionGroupAffiliation(), step.getNametest(), this.result);
                }
                break;
            }
            case 16: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3) continue;
                    this.addComponent(((XSTypeDefinition)this.currentComponents.get(i)).getBaseType(), step.getNametest(), this.result);
                }
                break;
            }
            case 17: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(xSObject = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    this.addComponent(((XSSimpleTypeDefinition)xSObject).getItemType(), step.getNametest(), this.result);
                }
                break;
            }
            case 18: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(xSObject = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    XSObjectList xSObjectList = ((XSSimpleTypeDefinition)xSObject).getMemberTypes();
                    int n3 = xSObjectList.size();
                    for (int j = 0; j < n3; ++j) {
                        this.addComponent((XSObject)xSObjectList.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 19: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(xSObject = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    this.addComponent(((XSSimpleTypeDefinition)xSObject).getPrimitiveType(), step.getNametest(), this.result);
                }
                break;
            }
            case 20: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    if (((XSObject)this.currentComponents.get(i)).getType() != 10) continue;
                    this.addComponent(((XSIDCDefinition)this.currentComponents.get(i)).getRefKey(), step.getNametest(), this.result);
                }
                break;
            }
            case 21: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.annotations((XSObject)this.currentComponents.get(i), this.result);
                }
                break;
            }
            case 24: {
                XSObjectList xSObjectList = null;
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject = (XSObject)this.currentComponents.get(i);
                    if (xSObject.getType() == 3) {
                        if (((XSTypeDefinition)xSObject).getTypeCategory() == 15) {
                            xSObjectList = ((XSComplexTypeDefinition)xSObject).getAttributeUses();
                        }
                    } else if (xSObject.getType() == 5) {
                        xSObjectList = ((XSAttributeGroupDefinition)xSObject).getAttributeUses();
                    }
                    if (xSObjectList == null) continue;
                    int n4 = xSObjectList.size();
                    for (int j = 0; j < n4; ++j) {
                        this.addComponent((XSObject)xSObjectList.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 25: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject xSObject = (XSObject)this.currentComponents.get(i);
                    if (xSObject.getType() != 7) continue;
                    XSObjectList xSObjectList = ((XSModelGroup)xSObject).getParticles();
                    int n5 = xSObjectList.size();
                    for (int j = 0; j < n5; ++j) {
                        this.addComponent((XSObject)xSObjectList.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 26: {
                throw new SCDException("Error in SCD: Extension axis is not supported");
            }
            default: {
                throw new SCDException("Error in SCD: Unsupported axis type " + step.getAxisName());
            }
        }
        this.applyPredicate(step.getPredicate());
    }

    private void addTopLevelComponents(QName qName) {
        XSObjectList xSObjectList = this.xsModel.getAnnotations();
        int n = xSObjectList.size();
        for (int i = 0; i < n; ++i) {
            this.addComponent(xSObjectList.item(i), qName, this.result);
        }
        short[] sArray = new short[]{2, 3, 1, 5, 6, 11};
        for (int i = 0; i < sArray.length; ++i) {
            XSNamedMap xSNamedMap = this.xsModel.getComponents(sArray[i]);
            if (xSNamedMap.isEmpty()) continue;
            int n2 = xSNamedMap.size();
            for (int j = 0; j < n2; ++j) {
                this.addComponent(xSNamedMap.item(i), qName, this.result);
            }
        }
    }

    private void applyPredicate(int n) throws SCDException {
        if (n == 0) {
            return;
        }
        if (n <= 0 || n > this.result.size()) {
            throw new SCDException("Error in SCD: Invalid predicate value (" + n + ") detected");
        }
        XSObject xSObject = (XSObject)this.result.get(n - 1);
        this.result.clear();
        this.result.add(xSObject);
    }

    private void term(XSObject xSObject, short s, QName qName, List list) {
        switch (xSObject.getType()) {
            case 6: {
                if (-1 != s && 7 != s) break;
                this.addComponent(((XSModelGroupDefinition)xSObject).getModelGroup(), qName, list);
                break;
            }
            case 3: {
                XSParticle xSParticle;
                if (((XSTypeDefinition)xSObject).getTypeCategory() != 15 || (xSParticle = ((XSComplexTypeDefinition)xSObject).getParticle()) == null) break;
                XSTerm xSTerm = xSParticle.getTerm();
                if (-1 != s && (xSTerm == null || xSTerm.getType() != s)) break;
                this.addComponent(xSTerm, qName, list);
                break;
            }
            case 8: {
                XSTerm xSTerm = ((XSParticle)xSObject).getTerm();
                if (-1 != s && (xSTerm == null || xSTerm.getType() != s)) break;
                this.addComponent(xSTerm, qName, list);
                break;
            }
            case 7: {
                XSObjectList xSObjectList = ((XSModelGroup)xSObject).getParticles();
                int n = xSObjectList.size();
                for (int i = 0; i < n; ++i) {
                    XSTerm xSTerm = ((XSParticle)xSObjectList.item(i)).getTerm();
                    if (-1 != s && (xSTerm == null || xSTerm.getType() != s)) continue;
                    this.addComponent(xSTerm, qName, list);
                }
                break;
            }
        }
    }

    private String componentVariety(XSObject xSObject) {
        short s = xSObject.getType();
        if (s == 7) {
            switch (((XSModelGroup)xSObject).getCompositor()) {
                case 1: {
                    return "sequence";
                }
                case 3: {
                    return "all";
                }
                case 2: {
                    return "choice";
                }
            }
        } else if (s == 13 || s == 14) {
            int n = -1;
            n = s == 13 ? (int)((XSFacet)xSObject).getFacetKind() : (int)((XSMultiValueFacet)xSObject).getFacetKind();
            switch (n) {
                case 2048: {
                    return "enumeration";
                }
                case 1024: {
                    return "fractionDigits";
                }
                case 1: {
                    return "length";
                }
                case 64: {
                    return "maxExclusive";
                }
                case 32: {
                    return "maxInclusive";
                }
                case 4: {
                    return "maxLength";
                }
                case 128: {
                    return "minExclusive";
                }
                case 256: {
                    return "minInclusive";
                }
                case 2: {
                    return "minLength";
                }
                case 8: {
                    return "pattern";
                }
                case 512: {
                    return "totalDigits";
                }
                case 16: {
                    return "whiteSpace";
                }
            }
        }
        return null;
    }

    private void componentLinked(XSObject xSObject, short s, QName qName, List list) throws SCDException {
        switch (xSObject.getType()) {
            case 1: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 == s || 12 == s) {
                    this.annotations(xSObject, list);
                }
                if (-1 != s && 3 != s || ((XSAttributeDeclaration)xSObject).getScope() != 2) break;
                this.addComponent(((XSAttributeDeclaration)xSObject).getEnclosingCTDefinition(), qName, list);
                break;
            }
            case 2: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 == s || 12 == s) {
                    this.annotations(xSObject, list);
                }
                if ((-1 == s || 3 == s) && ((XSElementDeclaration)xSObject).getScope() == 2) {
                    this.addComponent(((XSElementDeclaration)xSObject).getEnclosingCTDefinition(), qName, list);
                }
                if (-1 == s || 10 == s) {
                    XSNamedMap xSNamedMap = ((XSElementDeclaration)xSObject).getIdentityConstraints();
                    int n = xSNamedMap.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(xSNamedMap.item(i), qName, list);
                    }
                }
                if (-1 != s && 2 != s) break;
                this.addComponent(((XSElementDeclaration)xSObject).getSubstitutionGroupAffiliation(), qName, list);
                break;
            }
            case 3: {
                if (((XSTypeDefinition)xSObject).getTypeCategory() == 16) {
                    this.componentChildren(xSObject, s, qName, list);
                    if (-1 == s || 12 == s) {
                        this.annotations(xSObject, list);
                    }
                    if (-1 != s && 3 != s) break;
                    this.addComponent(((XSSimpleTypeDefinition)xSObject).getBaseType(), qName, list);
                    this.addComponent(((XSSimpleTypeDefinition)xSObject).getPrimitiveType(), qName, list);
                    this.addComponent(((XSSimpleTypeDefinition)xSObject).getItemType(), qName, list);
                    XSObjectList xSObjectList = ((XSSimpleTypeDefinition)xSObject).getMemberTypes();
                    int n = xSObjectList.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(xSObjectList.item(i), qName, list);
                    }
                    break;
                }
                this.componentChildren(xSObject, s, qName, list);
                if (-1 == s || 12 == s) {
                    this.annotations(xSObject, list);
                }
                if (-1 == s || 3 == s) {
                    this.addComponent(((XSComplexTypeDefinition)xSObject).getBaseType(), qName, list);
                }
                if (-1 != s && 9 != s) break;
                this.addComponent(((XSComplexTypeDefinition)xSObject).getAttributeWildcard(), qName, list);
                break;
            }
            case 4: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 5: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 == s || 12 == s) {
                    this.annotations(xSObject, list);
                }
                if (-1 != s && 9 != s) break;
                this.addComponent(((XSAttributeGroupDefinition)xSObject).getAttributeWildcard(), qName, list);
                break;
            }
            case 6: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 7: {
                this.componentChildren(xSObject, s, qName, list);
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 8: {
                this.componentChildren(xSObject, s, qName, list);
                break;
            }
            case 9: {
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 10: {
                if (-1 == s || 12 == s) {
                    this.annotations(xSObject, list);
                }
                if (-1 != s && 10 != s) break;
                this.addComponent(((XSIDCDefinition)xSObject).getRefKey(), qName, list);
                break;
            }
            case 11: {
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 13: {
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
            case 14: {
                if (-1 != s && 12 != s) break;
                this.annotations(xSObject, list);
                break;
            }
        }
    }

    private void componentChildren(XSObject xSObject, short s, QName qName, List list) {
        block0 : switch (xSObject.getType()) {
            case 1: {
                if (-1 != s && 3 != s) break;
                this.addComponent(((XSAttributeDeclaration)xSObject).getTypeDefinition(), qName, list);
                break;
            }
            case 2: {
                if (-1 != s && 3 != s) break;
                this.addComponent(((XSElementDeclaration)xSObject).getTypeDefinition(), qName, list);
                break;
            }
            case 3: {
                if (((XSTypeDefinition)xSObject).getTypeCategory() == 16) {
                    int n;
                    if (-1 != s && 13 != s) break;
                    XSObjectList xSObjectList = ((XSSimpleTypeDefinition)xSObject).getFacets();
                    int n2 = xSObjectList.size();
                    for (n = 0; n < n2; ++n) {
                        this.addComponent(xSObjectList.item(n), qName, list);
                    }
                    xSObjectList = ((XSSimpleTypeDefinition)xSObject).getMultiValueFacets();
                    n2 = xSObjectList.size();
                    for (n = 0; n < n2; ++n) {
                        this.addComponent(xSObjectList.item(n), qName, list);
                    }
                    break;
                }
                XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSObject;
                if (-1 == s || 4 == s) {
                    XSObjectList xSObjectList = xSComplexTypeDefinition.getAttributeUses();
                    int n = xSObjectList.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(xSObjectList.item(i), qName, list);
                    }
                }
                short s2 = xSComplexTypeDefinition.getContentType();
                switch (s2) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        if (-1 != s && 3 != s) break block0;
                        this.addComponent(xSComplexTypeDefinition.getSimpleType(), qName, list);
                        break block0;
                    }
                }
                this.term(xSComplexTypeDefinition, s, qName, list);
                break;
            }
            case 4: {
                if (-1 != s && 1 != s) break;
                this.addComponent(((XSAttributeUse)xSObject).getAttrDeclaration(), qName, list);
                break;
            }
            case 5: {
                if (-1 != s && 1 != s) break;
                XSObjectList xSObjectList = ((XSAttributeGroupDefinition)xSObject).getAttributeUses();
                int n = xSObjectList.size();
                for (int i = 0; i < n; ++i) {
                    this.addComponent(((XSAttributeUse)xSObjectList.item(i)).getAttrDeclaration(), qName, list);
                }
                break;
            }
            case 6: {
                if (-1 != s && 7 != s) break;
                this.addComponent(((XSModelGroupDefinition)xSObject).getModelGroup(), qName, list);
                break;
            }
            case 7: {
                XSObjectList xSObjectList = ((XSModelGroup)xSObject).getParticles();
                int n = xSObjectList.size();
                for (int i = 0; i < n; ++i) {
                    XSTerm xSTerm = ((XSParticle)xSObjectList.item(i)).getTerm();
                    if (-1 != s && xSTerm.getType() != s) continue;
                    this.addComponent(xSTerm, qName, list);
                }
                break;
            }
            case 8: {
                XSTerm xSTerm = ((XSParticle)xSObject).getTerm();
                if (-1 != s && xSTerm.getType() != s) break;
                this.addComponent(xSTerm, qName, list);
                break;
            }
        }
    }

    private void annotations(XSObject xSObject, List list) throws SCDException {
        XSObjectList xSObjectList;
        switch (xSObject.getType()) {
            case 1: {
                xSObjectList = ((XSAttributeDeclaration)xSObject).getAnnotations();
                break;
            }
            case 2: {
                xSObjectList = ((XSElementDeclaration)xSObject).getAnnotations();
                break;
            }
            case 3: {
                if (((XSTypeDefinition)xSObject).getTypeCategory() == 15) {
                    xSObjectList = ((XSComplexTypeDefinition)xSObject).getAnnotations();
                    break;
                }
                xSObjectList = ((XSSimpleTypeDefinition)xSObject).getAnnotations();
                break;
            }
            case 4: {
                xSObjectList = ((XSAttributeUse)xSObject).getAnnotations();
                break;
            }
            case 5: {
                xSObjectList = ((XSAttributeGroupDefinition)xSObject).getAnnotations();
                break;
            }
            case 7: {
                xSObjectList = ((XSModelGroup)xSObject).getAnnotations();
                break;
            }
            case 6: {
                xSObjectList = ((XSModelGroupDefinition)xSObject).getAnnotations();
                break;
            }
            case 8: {
                xSObjectList = ((XSParticle)xSObject).getAnnotations();
                break;
            }
            case 9: {
                xSObjectList = ((XSWildcard)xSObject).getAnnotations();
                break;
            }
            case 10: {
                xSObjectList = ((XSIDCDefinition)xSObject).getAnnotations();
                break;
            }
            case 11: {
                xSObjectList = ((XSNotationDeclaration)xSObject).getAnnotations();
                break;
            }
            case 13: {
                xSObjectList = ((XSFacet)xSObject).getAnnotations();
                break;
            }
            case 14: {
                xSObjectList = ((XSMultiValueFacet)xSObject).getAnnotations();
                break;
            }
            default: {
                throw new SCDException("Error in SCD: annotations accessor is not supported for the component type " + xSObject.getType());
            }
        }
        if (xSObjectList != null) {
            int n = xSObjectList.size();
            for (int i = 0; i < n; ++i) {
                XSObject xSObject2 = xSObjectList.item(i);
                if (xSObject2 == null || list.contains(xSObject2)) continue;
                list.add(xSObject2);
            }
        }
    }

    private void componentScope(XSObject xSObject, List list) {
        switch (xSObject.getType()) {
            case 1: {
                XSComplexTypeDefinition xSComplexTypeDefinition;
                if (((XSAttributeDeclaration)xSObject).getScope() == 1 || (xSComplexTypeDefinition = ((XSAttributeDeclaration)xSObject).getEnclosingCTDefinition()) == null || list.contains(xSComplexTypeDefinition)) break;
                list.add(xSComplexTypeDefinition);
                break;
            }
            case 2: {
                XSComplexTypeDefinition xSComplexTypeDefinition;
                if (((XSElementDeclaration)xSObject).getScope() == 1 || (xSComplexTypeDefinition = ((XSElementDeclaration)xSObject).getEnclosingCTDefinition()) == null || list.contains(xSComplexTypeDefinition)) break;
                list.add(xSComplexTypeDefinition);
            }
        }
    }

    private void addComponent(XSObject xSObject, QName qName, List list) {
        if (xSObject == null || list.contains(xSObject)) {
            return;
        }
        if (qName == SCDParser.ZERO) {
            if (xSObject.getType() == 3 && xSObject.getName() == null) {
                list.add(xSObject);
            }
        } else if (qName == SCDParser.WILDCARD) {
            list.add(xSObject);
        } else {
            String string = xSObject.getName();
            String string2 = xSObject.getNamespace();
            if (string2 != null && string != null) {
                if (string2.equals(qName.uri) && string.equals(qName.localpart)) {
                    list.add(xSObject);
                }
            } else if (string2 == null && string != null) {
                if (qName.uri == null && string.equals(qName.localpart)) {
                    list.add(xSObject);
                }
            } else if (string2 == null && string == null) {
                String string3 = null;
                short s = xSObject.getType();
                if (s == 7 || s == 13 || s == 14) {
                    string3 = this.componentVariety(xSObject);
                    if (qName.uri == null && qName.localpart.equals(string3)) {
                        list.add(xSObject);
                    }
                }
            }
        }
    }

    public String toString() {
        return "(current components=" + this.currentComponents.toString() + ", result=" + this.result.toString() + ")";
    }
}

