/*
 * Decompiled with CFR 0.152.
 */
package repackage.javax.xml.stream;

import java.util.Iterator;
import repackage.javax.xml.namespace.NamespaceContext;
import repackage.javax.xml.namespace.QName;
import repackage.javax.xml.stream.FactoryConfigurationError;
import repackage.javax.xml.stream.FactoryFinder;
import repackage.javax.xml.stream.Location;
import repackage.javax.xml.stream.SecuritySupport;
import repackage.javax.xml.stream.events.Attribute;
import repackage.javax.xml.stream.events.Characters;
import repackage.javax.xml.stream.events.Comment;
import repackage.javax.xml.stream.events.DTD;
import repackage.javax.xml.stream.events.EndDocument;
import repackage.javax.xml.stream.events.EndElement;
import repackage.javax.xml.stream.events.EntityDeclaration;
import repackage.javax.xml.stream.events.EntityReference;
import repackage.javax.xml.stream.events.Namespace;
import repackage.javax.xml.stream.events.ProcessingInstruction;
import repackage.javax.xml.stream.events.StartDocument;
import repackage.javax.xml.stream.events.StartElement;

public abstract class XMLEventFactory {
    private static final String PROPERTY_NAME = "repackage.javax.xml.stream.XMLEventFactory";
    private static final String DEFAULT_FACTORY = "repackage.org.apache.xerces.stax.XMLEventFactoryImpl";

    protected XMLEventFactory() {
    }

    public static XMLEventFactory newInstance() throws FactoryConfigurationError {
        try {
            return (XMLEventFactory)FactoryFinder.find(PROPERTY_NAME, DEFAULT_FACTORY);
        }
        catch (FactoryFinder.ConfigurationError configurationError) {
            throw new FactoryConfigurationError(configurationError.getException(), configurationError.getMessage());
        }
    }

    public static XMLEventFactory newInstance(String string, ClassLoader classLoader) throws FactoryConfigurationError {
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        try {
            return (XMLEventFactory)FactoryFinder.find(string, classLoader, DEFAULT_FACTORY);
        }
        catch (FactoryFinder.ConfigurationError configurationError) {
            throw new FactoryConfigurationError(configurationError.getException(), configurationError.getMessage());
        }
    }

    public abstract void setLocation(Location var1);

    public abstract Attribute createAttribute(QName var1, String var2);

    public abstract Attribute createAttribute(String var1, String var2);

    public abstract Attribute createAttribute(String var1, String var2, String var3, String var4);

    public abstract Namespace createNamespace(String var1);

    public abstract Namespace createNamespace(String var1, String var2);

    public abstract StartElement createStartElement(QName var1, Iterator var2, Iterator var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5, NamespaceContext var6);

    public abstract EndElement createEndElement(QName var1, Iterator var2);

    public abstract EndElement createEndElement(String var1, String var2, String var3);

    public abstract EndElement createEndElement(String var1, String var2, String var3, Iterator var4);

    public abstract Characters createCharacters(String var1);

    public abstract Characters createCData(String var1);

    public abstract Characters createSpace(String var1);

    public abstract Characters createIgnorableSpace(String var1);

    public abstract StartDocument createStartDocument();

    public abstract StartDocument createStartDocument(String var1);

    public abstract StartDocument createStartDocument(String var1, String var2);

    public abstract StartDocument createStartDocument(String var1, String var2, boolean var3);

    public abstract EndDocument createEndDocument();

    public abstract EntityReference createEntityReference(String var1, EntityDeclaration var2);

    public abstract Comment createComment(String var1);

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2);

    public abstract DTD createDTD(String var1);
}

