/*
 * Decompiled with CFR 0.152.
 */
package repackage.java_cup;

import java.util.Enumeration;
import java.util.Hashtable;
import repackage.java_cup.action_part;
import repackage.java_cup.action_production;
import repackage.java_cup.emit;
import repackage.java_cup.internal_error;
import repackage.java_cup.non_terminal;
import repackage.java_cup.production_part;
import repackage.java_cup.symbol;
import repackage.java_cup.symbol_part;
import repackage.java_cup.terminal;
import repackage.java_cup.terminal_set;

public class production {
    protected static Hashtable _all = new Hashtable();
    protected static int next_index;
    protected symbol_part _lhs;
    protected int _rhs_prec = -1;
    protected int _rhs_assoc = -1;
    protected production_part[] _rhs;
    protected int _rhs_length;
    protected action_part _action;
    protected int _index;
    protected int _num_reductions = 0;
    protected boolean _nullable_known = false;
    protected boolean _nullable = false;
    protected terminal_set _first_set = new terminal_set();

    public production(non_terminal lhs_sym, production_part[] rhs_parts, int rhs_l, String action_str) throws internal_error {
        int rightlen = rhs_l;
        this._rhs_length = rhs_l >= 0 ? rhs_l : (rhs_parts != null ? rhs_parts.length : 0);
        if (lhs_sym == null) {
            throw new internal_error("Attempt to construct a production with a null LHS");
        }
        if (rhs_l > 0) {
            rightlen = rhs_parts[rhs_l - 1].is_action() ? rhs_l - 1 : rhs_l;
        }
        String declare_str = this.declare_labels(rhs_parts, rightlen, action_str);
        action_str = action_str == null ? declare_str : declare_str + action_str;
        lhs_sym.note_use();
        this._lhs = new symbol_part(lhs_sym);
        this._rhs_length = this.merge_adjacent_actions(rhs_parts, this._rhs_length);
        action_part tail_action = this.strip_trailing_action(rhs_parts, this._rhs_length);
        if (tail_action != null) {
            --this._rhs_length;
        }
        this._rhs = new production_part[this._rhs_length];
        for (int i = 0; i < this._rhs_length; ++i) {
            this._rhs[i] = rhs_parts[i];
            if (this._rhs[i].is_action()) continue;
            ((symbol_part)this._rhs[i]).the_symbol().note_use();
            if (!(((symbol_part)this._rhs[i]).the_symbol() instanceof terminal)) continue;
            this._rhs_prec = ((terminal)((symbol_part)this._rhs[i]).the_symbol()).precedence_num();
            this._rhs_assoc = ((terminal)((symbol_part)this._rhs[i]).the_symbol()).precedence_side();
        }
        if (action_str == null) {
            action_str = "";
        }
        if (tail_action != null && tail_action.code_string() != null) {
            action_str = action_str + "\t\t" + tail_action.code_string();
        }
        this._action = new action_part(action_str);
        this.remove_embedded_actions();
        this._index = next_index++;
        _all.put(new Integer(this._index), this);
        lhs_sym.add_production(this);
    }

    public production(non_terminal lhs_sym, production_part[] rhs_parts, int rhs_l) throws internal_error {
        this(lhs_sym, rhs_parts, rhs_l, null);
    }

    public production(non_terminal lhs_sym, production_part[] rhs_parts, int rhs_l, String action_str, int prec_num, int prec_side) throws internal_error {
        this(lhs_sym, rhs_parts, rhs_l, action_str);
        this.set_precedence_num(prec_num);
        this.set_precedence_side(prec_side);
    }

    public production(non_terminal lhs_sym, production_part[] rhs_parts, int rhs_l, int prec_num, int prec_side) throws internal_error {
        this(lhs_sym, rhs_parts, rhs_l, null);
        this.set_precedence_num(prec_num);
        this.set_precedence_side(prec_side);
    }

    public static Enumeration all() {
        return _all.elements();
    }

    public static production find(int indx) {
        return (production)_all.get(new Integer(indx));
    }

    public static int number() {
        return _all.size();
    }

    public symbol_part lhs() {
        return this._lhs;
    }

    public int precedence_num() {
        return this._rhs_prec;
    }

    public int precedence_side() {
        return this._rhs_assoc;
    }

    public void set_precedence_num(int prec_num) {
        this._rhs_prec = prec_num;
    }

    public void set_precedence_side(int prec_side) {
        this._rhs_assoc = prec_side;
    }

    public production_part rhs(int indx) throws internal_error {
        if (indx >= 0 && indx < this._rhs_length) {
            return this._rhs[indx];
        }
        throw new internal_error("Index out of range for right hand side of production");
    }

    public int rhs_length() {
        return this._rhs_length;
    }

    public action_part action() {
        return this._action;
    }

    public int index() {
        return this._index;
    }

    public int num_reductions() {
        return this._num_reductions;
    }

    public void note_reduction_use() {
        ++this._num_reductions;
    }

    public boolean nullable_known() {
        return this._nullable_known;
    }

    public boolean nullable() {
        return this._nullable;
    }

    public terminal_set first_set() {
        return this._first_set;
    }

    protected static boolean is_id_start(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    protected static boolean is_id_char(char c) {
        return production.is_id_start(c) || c >= '0' && c <= '9';
    }

    protected String make_declaration(String labelname, String stack_type, int offset) {
        String ret = emit.lr_values() ? "\t\tint " + labelname + "left = ((java_cup.runtime.Symbol)" + emit.pre("stack") + ".elementAt(" + emit.pre("top") + "-" + offset + ")).left;\n" + "\t\tint " + labelname + "right = ((java_cup.runtime.Symbol)" + emit.pre("stack") + ".elementAt(" + emit.pre("top") + "-" + offset + ")).right;\n" : "";
        return ret + "\t\t" + stack_type + " " + labelname + " = (" + stack_type + ")((" + "repackage.java_cup.runtime.Symbol) " + emit.pre("stack") + ".elementAt(" + emit.pre("top") + "-" + offset + ")).value;\n";
    }

    protected String declare_labels(production_part[] rhs, int rhs_len, String final_action) {
        String declaration = "";
        for (int pos = 0; pos < rhs_len; ++pos) {
            symbol_part part;
            if (rhs[pos].is_action() || (part = (symbol_part)rhs[pos]).label() == null) continue;
            declaration = declaration + this.make_declaration(part.label(), part.the_symbol().stack_type(), rhs_len - pos - 1);
        }
        return declaration;
    }

    protected int merge_adjacent_actions(production_part[] rhs_parts, int len) {
        if (rhs_parts == null || len == 0) {
            return 0;
        }
        int merge_cnt = 0;
        int to_loc = -1;
        for (int from_loc = 0; from_loc < len; ++from_loc) {
            if (!(to_loc >= 0 && rhs_parts[to_loc].is_action() && rhs_parts[from_loc].is_action() || ++to_loc == from_loc)) {
                rhs_parts[to_loc] = null;
            }
            if (to_loc == from_loc) continue;
            if (rhs_parts[to_loc] != null && rhs_parts[to_loc].is_action() && rhs_parts[from_loc].is_action()) {
                rhs_parts[to_loc] = new action_part(((action_part)rhs_parts[to_loc]).code_string() + ((action_part)rhs_parts[from_loc]).code_string());
                ++merge_cnt;
                continue;
            }
            rhs_parts[to_loc] = rhs_parts[from_loc];
        }
        return len - merge_cnt;
    }

    protected action_part strip_trailing_action(production_part[] rhs_parts, int len) {
        if (rhs_parts == null || len == 0) {
            return null;
        }
        if (rhs_parts[len - 1].is_action()) {
            action_part result = (action_part)rhs_parts[len - 1];
            rhs_parts[len - 1] = null;
            return result;
        }
        return null;
    }

    protected void remove_embedded_actions() throws internal_error {
        for (int act_loc = 0; act_loc < this.rhs_length(); ++act_loc) {
            if (!this.rhs(act_loc).is_action()) continue;
            String declare_str = this.declare_labels(this._rhs, act_loc, "");
            non_terminal new_nt = non_terminal.create_new();
            new_nt.is_embedded_action = true;
            action_production new_prod = new action_production(this, new_nt, null, 0, declare_str + ((action_part)this.rhs(act_loc)).code_string());
            this._rhs[act_loc] = new symbol_part(new_nt);
        }
    }

    public boolean check_nullable() throws internal_error {
        if (this.nullable_known()) {
            return this.nullable();
        }
        if (this.rhs_length() == 0) {
            return this.set_nullable(true);
        }
        for (int pos = 0; pos < this.rhs_length(); ++pos) {
            production_part part = this.rhs(pos);
            if (part.is_action()) continue;
            symbol sym2 = ((symbol_part)part).the_symbol();
            if (!sym2.is_non_term()) {
                return this.set_nullable(false);
            }
            if (((non_terminal)sym2).nullable()) continue;
            return false;
        }
        return this.set_nullable(true);
    }

    boolean set_nullable(boolean v) {
        this._nullable_known = true;
        this._nullable = v;
        return v;
    }

    public terminal_set check_first_set() throws internal_error {
        for (int part = 0; part < this.rhs_length(); ++part) {
            if (this.rhs(part).is_action()) continue;
            symbol sym2 = ((symbol_part)this.rhs(part)).the_symbol();
            if (sym2.is_non_term()) {
                this._first_set.add(((non_terminal)sym2).first_set());
                if (((non_terminal)sym2).nullable()) continue;
                break;
            }
            this._first_set.add((terminal)sym2);
            break;
        }
        return this.first_set();
    }

    public boolean equals(production other) {
        if (other == null) {
            return false;
        }
        return other._index == this._index;
    }

    public boolean equals(Object other) {
        if (!(other instanceof production)) {
            return false;
        }
        return this.equals((production)other);
    }

    public int hashCode() {
        return this._index * 13;
    }

    public String toString() {
        String result;
        try {
            result = "production [" + this.index() + "]: ";
            result = result + (this.lhs() != null ? this.lhs().toString() : "$$NULL-LHS$$");
            result = result + " :: = ";
            for (int i = 0; i < this.rhs_length(); ++i) {
                result = result + this.rhs(i) + " ";
            }
            result = result + ";";
            if (this.action() != null && this.action().code_string() != null) {
                result = result + " {" + this.action().code_string() + "}";
            }
            if (this.nullable_known()) {
                result = this.nullable() ? result + "[NULLABLE]" : result + "[NOT NULLABLE]";
            }
        }
        catch (internal_error e) {
            e.crash();
            result = null;
        }
        return result;
    }

    public String to_simple_string() throws internal_error {
        String result = this.lhs() != null ? this.lhs().the_symbol().name() : "NULL_LHS";
        result = result + " ::= ";
        for (int i = 0; i < this.rhs_length(); ++i) {
            if (this.rhs(i).is_action()) continue;
            result = result + ((symbol_part)this.rhs(i)).the_symbol().name() + " ";
        }
        return result;
    }
}

